/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta.integration;

import io.narayana.db.Allocator;
import io.narayana.db.DB;
import io.narayana.db.DBAllocator;
import io.narayana.db.H2Allocator;
import io.narayana.db.PostgreContainerAllocator;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractCase {
    private static final Logger LOGGER = Logger.getLogger(AbstractCase.class.getName());
    static WebArchive webArchive;
    static Allocator dba;
    static DB db;
    private static File[] libFiles;
    static String dbDriverAbsolutePath;
    static String catalinaHome;

    @BeforeClass
    public static void init() {
        try {
            File[] fileArray;
            dba = Allocator.getInstance();
            LOGGER.info("Allocating a new database might take many minutes, depending on the mode the test suite operates in.");
            db = dba.allocateDB();
            Assert.assertNotNull((String)"Failed to allocate DB. Check logs for the root cause.", (Object)db);
            AbstractCase.prepareContextXML();
            if (dba instanceof DBAllocator) {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = new File(AbstractCase.db.dbDriverArtifact);
            } else {
                fileArray = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(AbstractCase.db.dbDriverArtifact)).withTransitivity()).asFile();
            }
            File[] dbDriver = fileArray;
            dbDriverAbsolutePath = dbDriver[0].getAbsolutePath();
            AbstractCase.executeTestStatement(dbDriverAbsolutePath, db, dba);
            Assert.assertNotNull((String)"WebArchive was not created by @Deployment before @BeforeClass. Arquillian lifecycle config error?", (Object)webArchive);
            webArchive.addAsLibraries(dbDriver);
            webArchive.addAsManifestResource("context.xml", "context.xml");
            String versionTXSpec = System.getProperty("version.org.jboss.spec.javax.transaction");
            if (StringUtils.isEmpty((String)versionTXSpec)) {
                throw new IllegalArgumentException("version.org.jboss.spec.javax.transaction must not be empty");
            }
            catalinaHome = System.getenv("CATALINA_HOME");
            if (StringUtils.isEmpty((String)catalinaHome)) {
                throw new IllegalArgumentException("CATALINA_HOME must not be empty");
            }
            libFiles = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve("org.jboss.spec.javax.transaction:jboss-transaction-api_1.2_spec:" + versionTXSpec)).withTransitivity()).asFile();
            String dest = catalinaHome + File.separator + "lib" + File.separator + libFiles[0].getName();
            try {
                Files.copy(Paths.get(libFiles[0].toURI()), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Either CATALINA_HOME or version.org.jboss.spec.javax.transaction is invalid, we cannot copy to " + dest, e);
                Assert.fail((String)e.getMessage());
            }
        }
        catch (IOException | NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Web app war archive generating or /lib dir configuration failed.", e);
            if (dba != null && db != null) {
                dba.deallocateDB(db);
            }
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void clean() {
        if (dba != null && db != null) {
            dba.deallocateDB(db);
        }
        if (libFiles != null && libFiles[0] != null) {
            String file0 = catalinaHome + File.separator + "lib" + File.separator + libFiles[0].getName();
            try {
                Files.delete(Paths.get(file0, new String[0]));
            }
            catch (IOException e) {
                LOGGER.info(file0 + " not found.");
            }
        }
    }

    private static void prepareContextXML() {
        try {
            File contextXML = new File(URLDecoder.decode(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            }).getResource("context.xml").getFile(), "UTF-8"));
            Document context = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contextXML);
            Element dbSource = context.createElement("Resource");
            dbSource.setAttribute("name", "myDataSource");
            dbSource.setAttribute("uniqueName", "myDataSource");
            dbSource.setAttribute("auth", "Container");
            dbSource.setAttribute("type", AbstractCase.db.dsType);
            dbSource.setAttribute("username", AbstractCase.db.dsUsername);
            dbSource.setAttribute("user", AbstractCase.db.dsUser);
            dbSource.setAttribute("password", AbstractCase.db.dsPassword);
            dbSource.setAttribute("url", AbstractCase.db.dsUrl);
            dbSource.setAttribute("description", "Data Source");
            dbSource.setAttribute("loginTimeout", AbstractCase.db.dsLoginTimeout);
            dbSource.setAttribute("factory", AbstractCase.db.dsFactory);
            if (!(dba instanceof H2Allocator)) {
                dbSource.setAttribute("databaseName", AbstractCase.db.dsDbName);
                dbSource.setAttribute("portNumber", AbstractCase.db.dsDbPort);
                dbSource.setAttribute("serverName", AbstractCase.db.dsDbHostname);
            }
            context.getDocumentElement().appendChild(dbSource);
            Element tsDbSource = context.createElement("Resource");
            tsDbSource.setAttribute("name", "transactionalDataSource");
            tsDbSource.setAttribute("uniqueName", "transactionalDataSource");
            tsDbSource.setAttribute("auth", "Container");
            tsDbSource.setAttribute("type", AbstractCase.db.tdsType);
            tsDbSource.setAttribute("username", AbstractCase.db.dsUser);
            tsDbSource.setAttribute("password", AbstractCase.db.dsPassword);
            tsDbSource.setAttribute("transactionManager", "TransactionManager");
            tsDbSource.setAttribute("xaDataSource", "myDataSource");
            tsDbSource.setAttribute("transactionSynchronizationRegistry", "TransactionSynchronizationRegistry");
            tsDbSource.setAttribute("description", "Transactional Driver Data Source");
            tsDbSource.setAttribute("factory", "org.jboss.narayana.tomcat.jta.TransactionalDataSourceFactory");
            tsDbSource.setAttribute("initialSize", "10");
            tsDbSource.setAttribute("maxWaitMillis", "10000");
            tsDbSource.setAttribute("maxTotal", "4");
            tsDbSource.setAttribute("maxIdle", "16");
            tsDbSource.setAttribute("minIdle", "8");
            tsDbSource.setAttribute("maxAge", "30000");
            tsDbSource.setAttribute("testOnBorrow", "true");
            tsDbSource.setAttribute("validationQuery", "select 1");
            tsDbSource.setAttribute("removeAbandonedTimeout", "60");
            tsDbSource.setAttribute("removeAbandoned", "true");
            tsDbSource.setAttribute("logAbandoned", "true");
            tsDbSource.setAttribute("jmxEnabled", "true");
            context.getDocumentElement().appendChild(tsDbSource);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(context), new StreamResult(contextXML));
        }
        catch (ParserConfigurationException | TransformerException | SAXException e) {
            Assert.fail((String)"Failed to parse, update and serialize web app's context.xml for data source configuration.");
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to locate context.xml to process.");
        }
    }

    static void executeTestStatement(String dbDriverAbsolutePath, DB db, Allocator dba) {
        if (dba instanceof PostgreContainerAllocator && StringUtils.isNotBlank((String)db.heartBeatStatement)) {
            try {
                if (!Allocator.executeTestStatement((DB)db, (String)dbDriverAbsolutePath)) {
                    dba.deallocateDB(db);
                    Assert.fail((String)"The database system is not ready to execute statements. Check DB logs, please.");
                }
            }
            catch (ClassNotFoundException e) {
                dba.deallocateDB(db);
                Assert.fail((String)("The class %s cannot be loaded. " + e.getMessage()));
            }
            catch (IllegalAccessException e) {
                dba.deallocateDB(db);
                Assert.fail((String)("Dynamic loading of Driver class is probably not possible with this JVM setup. " + e.getMessage()));
            }
            catch (InstantiationException e) {
                dba.deallocateDB(db);
                Assert.fail((String)("Dynamic Driver class instantiation failed. " + e.getMessage()));
            }
            catch (SQLException e) {
                dba.deallocateDB(db);
                Assert.fail((String)("Driver cannot be used. " + e.getMessage()));
            }
            catch (MalformedURLException e) {
                Assert.fail((String)("Driver jar path seems invalid. " + e.getMessage()));
            }
        }
    }
}

