/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.UserTransaction;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.managed.DataSourceXAConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.ManagedDataSource;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;
import org.jboss.narayana.tomcat.jta.DatabaseProvider;
import org.jboss.narayana.tomcat.jta.TransactionalDataSourceFactory;

public class PoolingDataSource
implements DataSource {
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";
    private static final Logger logger = Logger.getLogger(PoolingDataSource.class.getSimpleName());
    private Properties driverProperties = new Properties();
    private String uniqueName;
    private String className;
    private ManagedDataSource<?> managedDataSource;
    private DatabaseProvider databaseProvider;

    public PoolingDataSource(String uniqueName, String dsClassName) {
        this.uniqueName = uniqueName;
        this.className = dsClassName;
    }

    public PoolingDataSource() {
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    public void init() {
        this.init(new HashMap<String, Object>());
    }

    public void init(Map<String, Object> environment) {
        this.databaseProvider = DatabaseProvider.fromDriverClassName(this.className);
        XADataSource xaDataSource = this.createXaDataSource();
        TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
        TransactionSynchronizationRegistry tsr = jtaPropertyManager.getJTAEnvironmentBean().getTransactionSynchronizationRegistry();
        DataSourceXAConnectionFactory xaConnectionFactory = this.resolveDataSourceXAConnectionFactory(tm, xaDataSource, tsr);
        this.managedDataSource = this.createManagedDataSource(xaConnectionFactory, xaDataSource, environment);
        try {
            InitialContext initContext = new InitialContext();
            initContext.rebind(this.uniqueName, this.managedDataSource);
            initContext.rebind("java:comp/UserTransaction", (Object)UserTransaction.userTransaction());
            initContext.rebind("java:comp/TransactionManager", (Object)tm);
            initContext.rebind("java:comp/TransactionSynchronizationRegistry", (Object)tsr);
        }
        catch (NamingException e) {
            logger.warning("No InitialContext available, resource won't be accessible via lookup");
        }
    }

    private DataSourceXAConnectionFactory resolveDataSourceXAConnectionFactory(TransactionManager tm, XADataSource xaDataSource, TransactionSynchronizationRegistry tsr) {
        DataSourceXAConnectionFactory xaConnectionFactory;
        if (this.databaseProvider == DatabaseProvider.H2) {
            xaConnectionFactory = new DataSourceXAConnectionFactory(tm, xaDataSource, tsr);
        } else {
            String username = this.getUsernameFromDriverProperties();
            String password = this.getPasswordFromDriverProperties();
            xaConnectionFactory = new DataSourceXAConnectionFactory(tm, xaDataSource, username, Utils.toCharArray((String)password), tsr);
        }
        return xaConnectionFactory;
    }

    private XADataSource createXaDataSource() {
        try {
            XADataSource xaDataSource = (XADataSource)Class.forName(this.className).newInstance();
            String url = this.driverProperties.getProperty("url", this.driverProperties.getProperty("URL"));
            if (this.databaseProvider == DatabaseProvider.H2) {
                xaDataSource.getClass().getMethod("setUser", String.class).invoke((Object)xaDataSource, this.getUsernameFromDriverProperties());
                xaDataSource.getClass().getMethod("setPassword", String.class).invoke((Object)xaDataSource, this.getPasswordFromDriverProperties());
            }
            if (this.databaseProvider == DatabaseProvider.DB2 || this.databaseProvider == DatabaseProvider.SYBASE) {
                try {
                    xaDataSource.getClass().getMethod("setUrl", String.class).invoke((Object)xaDataSource, url);
                }
                catch (NoSuchMethodException ex) {
                    logger.info("Unable to find \"setUrl\" method in db driver JAR. Trying \"setURL\" ");
                    xaDataSource.getClass().getMethod("setURL", String.class).invoke((Object)xaDataSource, url);
                }
                catch (InvocationTargetException ex) {
                    logger.info("Driver does not support setURL and setUrl method.");
                    throw new RuntimeException(ex);
                }
            } else {
                this.setupAdditionalDriverProperties(xaDataSource);
            }
            return xaDataSource;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupAdditionalDriverProperties(XADataSource xaDataSource) {
        try {
            xaDataSource.getClass().getMethod("setServerName", String.class).invoke((Object)xaDataSource, this.driverProperties.getProperty("serverName"));
            xaDataSource.getClass().getMethod("setDatabaseName", String.class).invoke((Object)xaDataSource, this.driverProperties.getProperty("databaseName"));
            if (this.databaseProvider == DatabaseProvider.DB2) {
                xaDataSource.getClass().getMethod("setDriverType", Integer.TYPE).invoke((Object)xaDataSource, 4);
                xaDataSource.getClass().getMethod("setPortNumber", Integer.TYPE).invoke((Object)xaDataSource, Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                xaDataSource.getClass().getMethod("setResultSetHoldability", Integer.TYPE).invoke((Object)xaDataSource, 1);
                xaDataSource.getClass().getMethod("setDowngradeHoldCursorsUnderXa", Boolean.TYPE).invoke((Object)xaDataSource, true);
            } else if (this.databaseProvider == DatabaseProvider.SYBASE) {
                xaDataSource.getClass().getMethod("setPortNumber", Integer.TYPE).invoke((Object)xaDataSource, Integer.valueOf(this.driverProperties.getProperty("portNumber")));
                xaDataSource.getClass().getMethod("setPassword", String.class).invoke((Object)xaDataSource, this.driverProperties.getProperty(PROP_PASSWORD));
                xaDataSource.getClass().getMethod("setUser", String.class).invoke((Object)xaDataSource, this.driverProperties.getProperty("user"));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            logger.severe("Exception thrown while setting properties for {" + this.className + "} driver");
            throw new RuntimeException(ex);
        }
    }

    private ManagedDataSource<PoolableConnection> createManagedDataSource(DataSourceXAConnectionFactory xaConnectionFactory, XADataSource xaDataSource, Map<String, Object> environment) {
        PoolableConnectionFactory poolableConnectionFactory = this.getPoolableConnectionFactory(xaConnectionFactory, environment);
        GenericObjectPoolConfig<PoolableConnection> objectPoolConfig = this.getObjectPoolConfig(environment);
        AbandonedConfig abandonedConfig = this.getAbandonedConfig(environment);
        GenericObjectPool objectPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory, objectPoolConfig, abandonedConfig);
        poolableConnectionFactory.setPool((ObjectPool)objectPool);
        this.registerXARecoveryModule(xaDataSource, environment);
        return new ManagedDataSource((ObjectPool)objectPool, xaConnectionFactory.getTransactionRegistry());
    }

    private GenericObjectPoolConfig<PoolableConnection> getObjectPoolConfig(Map<String, Object> environment) {
        GenericObjectPoolConfig objectPoolConfig = new GenericObjectPoolConfig();
        this.setFromEnvironment("maxTotal", environment, value -> objectPoolConfig.setMaxTotal(((Integer)value).intValue()));
        this.setFromEnvironment("minIdle", environment, value -> objectPoolConfig.setMinIdle(((Integer)value).intValue()));
        this.setFromEnvironment("maxIdle", environment, value -> objectPoolConfig.setMaxIdle(((Integer)value).intValue()));
        this.setFromEnvironment("lifo", environment, value -> objectPoolConfig.setLifo(((Boolean)value).booleanValue()));
        this.setFromEnvironment("fairness", environment, value -> objectPoolConfig.setFairness(((Boolean)value).booleanValue()));
        this.setFromEnvironment("maxWaitMillis", environment, value -> objectPoolConfig.setMaxWaitMillis(((Long)value).longValue()));
        this.setFromEnvironment("minEvictableIdleTimeMillis", environment, value -> objectPoolConfig.setMinEvictableIdleTimeMillis(((Long)value).longValue()));
        this.setFromEnvironment("evictorShutdownTimeoutMillis", environment, value -> objectPoolConfig.setEvictorShutdownTimeoutMillis(((Long)value).longValue()));
        this.setFromEnvironment("softMinEvictableIdleTimeMillis", environment, value -> objectPoolConfig.setSoftMinEvictableIdleTimeMillis(((Long)value).longValue()));
        this.setFromEnvironment("numTestsPerEvictionRun", environment, value -> objectPoolConfig.setNumTestsPerEvictionRun(((Integer)value).intValue()));
        this.setFromEnvironment("evictionPolicyClassName", environment, value -> objectPoolConfig.setEvictionPolicyClassName((String)value));
        this.setFromEnvironment("testOnCreate", environment, value -> objectPoolConfig.setTestOnCreate(((Boolean)value).booleanValue()));
        this.setFromEnvironment("testOnBorrow", environment, value -> objectPoolConfig.setTestOnBorrow(((Boolean)value).booleanValue()));
        this.setFromEnvironment("testOnReturn", environment, value -> objectPoolConfig.setTestOnReturn(((Boolean)value).booleanValue()));
        this.setFromEnvironment("testWhileIdle", environment, value -> objectPoolConfig.setTestWhileIdle(((Boolean)value).booleanValue()));
        this.setFromEnvironment("timeBetweenEvictionRunsMillis", environment, value -> objectPoolConfig.setTimeBetweenEvictionRunsMillis(((Long)value).longValue()));
        this.setFromEnvironment("blockWhenExhausted", environment, value -> objectPoolConfig.setBlockWhenExhausted(((Boolean)value).booleanValue()));
        this.setFromEnvironment("jmxEnabled", environment, value -> objectPoolConfig.setJmxEnabled(((Boolean)value).booleanValue()));
        this.setFromEnvironment("jmxNamePrefix", environment, value -> objectPoolConfig.setJmxNamePrefix((String)value));
        this.setFromEnvironment("jmxNameBase", environment, value -> objectPoolConfig.setJmxNameBase((String)value));
        return objectPoolConfig;
    }

    private AbandonedConfig getAbandonedConfig(Map<String, Object> environment) {
        AbandonedConfig abandonedConfig = new AbandonedConfig();
        this.setFromEnvironment("removeAbandonedOnBorrow", environment, value -> abandonedConfig.setRemoveAbandonedOnBorrow(((Boolean)value).booleanValue()));
        this.setFromEnvironment("removeAbandonedOnMaintenance", environment, value -> abandonedConfig.setRemoveAbandonedOnMaintenance(((Boolean)value).booleanValue()));
        this.setFromEnvironment("removeAbandonedTimeout", environment, value -> abandonedConfig.setRemoveAbandonedTimeout(((Integer)value).intValue()));
        this.setFromEnvironment("logAbandoned", environment, value -> abandonedConfig.setLogAbandoned(((Boolean)value).booleanValue()));
        this.setFromEnvironment("requireFullStackTrace", environment, value -> abandonedConfig.setRequireFullStackTrace(((Boolean)value).booleanValue()));
        this.setFromEnvironment("useUsageTracking", environment, value -> abandonedConfig.setUseUsageTracking(((Boolean)value).booleanValue()));
        return abandonedConfig;
    }

    private PoolableConnectionFactory getPoolableConnectionFactory(DataSourceXAConnectionFactory xaDsConnectionFactory, Map<String, Object> environment) {
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)xaDsConnectionFactory, null);
        this.setFromEnvironment("validationQuery", environment, value -> poolableConnectionFactory.setValidationQuery((String)value));
        this.setFromEnvironment("validationQueryTimeout", environment, value -> poolableConnectionFactory.setValidationQueryTimeout(((Integer)value).intValue()));
        this.setFromEnvironment("connectionInitSqls", environment, value -> poolableConnectionFactory.setConnectionInitSql((Collection)value));
        this.setFromEnvironment("disconnectionSqlCodes", environment, value -> poolableConnectionFactory.setDisconnectionSqlCodes((Collection)value));
        this.setFromEnvironment("fastFailValidation", environment, value -> poolableConnectionFactory.setFastFailValidation(((Boolean)value).booleanValue()));
        this.setFromEnvironment("defaultTransactionIsolation", environment, value -> poolableConnectionFactory.setDefaultTransactionIsolation(((Integer)value).intValue()));
        this.setFromEnvironment("defaultCatalog", environment, value -> poolableConnectionFactory.setDefaultCatalog((String)value));
        this.setFromEnvironment("cacheState", environment, value -> poolableConnectionFactory.setCacheState(((Boolean)value).booleanValue()));
        return poolableConnectionFactory;
    }

    private void setFromEnvironment(String key, Map<String, Object> environment, Consumer<Object> setter) {
        Object value = environment.get(key);
        if (value != null) {
            setter.accept(value);
        }
    }

    private void registerXARecoveryModule(XADataSource xaDataSource, Map<String, Object> environment) {
        XARecoveryModule xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        if (xaRecoveryModule == null) {
            throw new IllegalStateException("XARecoveryModule is not registered with recovery manager");
        }
        Properties recoveryModuleProperties = new Properties();
        String username = (String)environment.get(PROP_USERNAME);
        String password = (String)environment.get(PROP_PASSWORD);
        if (username != null) {
            recoveryModuleProperties.setProperty(PROP_USERNAME, username);
        }
        if (password != null) {
            recoveryModuleProperties.setProperty(PROP_PASSWORD, password);
        }
        xaRecoveryModule.addXAResourceRecoveryHelper(TransactionalDataSourceFactory.getXAResourceRecoveryHelper(xaDataSource, recoveryModuleProperties));
    }

    private String getUsernameFromDriverProperties() {
        return this.driverProperties.getProperty("user");
    }

    private String getPasswordFromDriverProperties() {
        return this.driverProperties.getProperty(PROP_PASSWORD);
    }

    public void close() {
        try {
            this.managedDataSource.close();
            new InitialContext().unbind(this.uniqueName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.managedDataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.managedDataSource.getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.managedDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.managedDataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.managedDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.managedDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.managedDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.managedDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.managedDataSource.getParentLogger();
    }
}

