/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.tomcat.jta;

import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSource;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.managed.BasicManagedDataSource;

public class TransactionalDataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(TransactionalDataSourceFactory.class);
    private static final String PROP_TRANSACTION_MANAGER = "transactionManager";
    private static final String PROP_XA_DATASOURCE = "xaDataSource";
    private static final String PROP_TRANSACTION_SYNCHRONIZATION_REGISTRY = "transactionSynchronizationRegistry";
    private static final String PROP_USERNAME = "username";
    private static final String PROP_PASSWORD = "password";

    static XAResourceRecoveryHelper getXAResourceRecoveryHelper(final XADataSource xaDataSource, final Properties properties) {
        return new XAResourceRecoveryHelper(){
            private final Object lock = new Object();
            private XAConnection connection;

            public boolean initialise(String p) throws Exception {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized XAResource[] getXAResources() throws Exception {
                Object object = this.lock;
                synchronized (object) {
                    this.initialiseConnection();
                    try {
                        return new XAResource[]{this.connection.getXAResource()};
                    }
                    catch (SQLException ex) {
                        return new XAResource[0];
                    }
                }
            }

            private void initialiseConnection() throws SQLException {
                if (this.connection == null) {
                    String user = properties.getProperty(TransactionalDataSourceFactory.PROP_USERNAME);
                    String password = properties.getProperty(TransactionalDataSourceFactory.PROP_PASSWORD);
                    this.connection = user != null && password != null ? xaDataSource.getXAConnection(user, password) : xaDataSource.getXAConnection();
                    this.connection.addConnectionEventListener(new ConnectionEventListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void connectionClosed(ConnectionEvent event) {
                            log.warn((Object)("The connection was closed: " + connection));
                            Object object = lock;
                            synchronized (object) {
                                connection = null;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void connectionErrorOccurred(ConnectionEvent event) {
                            log.warn((Object)("A connection error occurred: " + connection));
                            Object object = lock;
                            synchronized (object) {
                                try {
                                    connection.close();
                                }
                                catch (SQLException e) {
                                    log.warn((Object)("Could not close failing connection: " + connection));
                                }
                                connection = null;
                            }
                        }
                    });
                }
            }
        };
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context context, Hashtable<?, ?> environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.XADataSource".equals(ref.getClassName())) {
            log.fatal((Object)String.format("The expected type of datasource was javax.sql.XADataSource and not %s.", ref.getClassName()));
            return null;
        }
        Properties properties = new Properties();
        Enumeration<RefAddr> iter = ref.getAll();
        while (iter.hasMoreElements()) {
            RefAddr ra = iter.nextElement();
            String type = ra.getType();
            String content = ra.getContent().toString();
            properties.setProperty(type, content);
        }
        TransactionManager transactionManager = (TransactionManager)this.getReferenceObject(ref, context, PROP_TRANSACTION_MANAGER);
        XADataSource xaDataSource = (XADataSource)this.getReferenceObject(ref, context, PROP_XA_DATASOURCE);
        TransactionSynchronizationRegistry tsr = (TransactionSynchronizationRegistry)this.getReferenceObject(ref, context, PROP_TRANSACTION_SYNCHRONIZATION_REGISTRY);
        if (transactionManager != null && xaDataSource != null) {
            XARecoveryModule xaRecoveryModule;
            String initialSize = properties.getProperty("initialSize");
            properties.remove("initialSize");
            BasicDataSource ds = BasicDataSourceFactory.createDataSource((Properties)properties);
            BasicManagedDataSource mds = new BasicManagedDataSource();
            for (Field field : ds.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(ds) == null || Modifier.isFinal(field.getModifiers())) continue;
                field.set(mds, field.get(ds));
            }
            mds.setTransactionManager(transactionManager);
            mds.setXaDataSourceInstance(xaDataSource);
            mds.setTransactionSynchronizationRegistry(tsr);
            if (initialSize != null) {
                mds.setInitialSize(Integer.parseInt(initialSize));
                if (mds.getInitialSize() > 0) {
                    mds.getLogWriter();
                }
            }
            if ((xaRecoveryModule = this.getXARecoveryModule()) != null) {
                xaRecoveryModule.addXAResourceRecoveryHelper(TransactionalDataSourceFactory.getXAResourceRecoveryHelper(xaDataSource, properties));
            }
            return mds;
        }
        return null;
    }

    private Object getReferenceObject(Reference ref, Context context, String prop) throws Exception {
        RefAddr ra = ref.get(prop);
        if (ra != null) {
            return context.lookup(ra.getContent().toString());
        }
        return null;
    }

    private XARecoveryModule getXARecoveryModule() {
        XARecoveryModule xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        if (xaRecoveryModule != null) {
            return xaRecoveryModule;
        }
        throw new IllegalStateException("XARecoveryModule is not registered with recovery manager");
    }
}

