/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InvocationMessages;

public final class InterceptorContext
implements Cloneable,
PrivilegedExceptionAction<Object> {
    private static final List<Interceptor> EMPTY = Collections.emptyList();
    private static final ListIterator<Interceptor> EMPTY_ITR = EMPTY.listIterator();
    private static final Map<Class<?>, Class<?>> PRIMITIVES;
    private Object target;
    private Method method;
    private Constructor<?> constructor;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;
    private List<Interceptor> interceptors = EMPTY;
    private ListIterator<Interceptor> interceptorIterator = EMPTY_ITR;
    private final Map<Object, Object> privateData = new IdentityHashMap<Object, Object>();
    private final InvocationContext invocationContext = new Invocation();

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() throws IllegalStateException {
        Map<String, Object> contextData = this.contextData;
        if (contextData == null) {
            throw new IllegalStateException("The context data was not set");
        }
        return contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setTimer(Object timer) {
        this.timer = timer;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public <T> T getPrivateData(Class<T> type) {
        return type.cast(this.privateData.get(type));
    }

    public Object getPrivateData(Object key) {
        return this.privateData.get(key);
    }

    public <T> T putPrivateData(Class<T> type, T value) {
        if (value == null) {
            return type.cast(this.privateData.remove(type));
        }
        return type.cast(this.privateData.put(type, type.cast(value)));
    }

    public Object putPrivateData(Object key, Object value) {
        if (key instanceof Class) {
            Class type = (Class)key;
            if (value == null) {
                return type.cast(this.privateData.remove(type));
            }
            return type.cast(this.privateData.put(type, type.cast(value)));
        }
        if (value == null) {
            return this.privateData.remove(key);
        }
        return this.privateData.put(key, value);
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public int getNextInterceptorIndex() {
        return this.interceptorIterator.nextIndex();
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.setInterceptors(interceptors, 0);
    }

    public void setInterceptors(List<Interceptor> interceptors, int nextIndex) {
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors is null");
        }
        this.interceptors = interceptors;
        this.interceptorIterator = interceptors.listIterator(nextIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        ListIterator<Interceptor> iterator = this.interceptorIterator;
        if (iterator.hasNext()) {
            Interceptor next = iterator.next();
            try {
                Object object = next.processInvocation(this);
                return object;
            }
            finally {
                if (iterator.hasPrevious()) {
                    iterator.previous();
                }
            }
        }
        throw InvocationMessages.msg.cannotProceed();
    }

    @Override
    public Object run() throws Exception {
        return this.proceed();
    }

    public InterceptorContext clone() {
        InterceptorContext clone = new InterceptorContext();
        Map<String, Object> contextData = this.contextData;
        if (contextData != null) {
            clone.contextData = new HashMap<String, Object>(contextData);
        }
        clone.privateData.putAll(this.privateData);
        clone.target = this.target;
        clone.method = this.method;
        clone.constructor = this.constructor;
        clone.parameters = this.parameters;
        clone.timer = this.timer;
        int next = this.interceptorIterator.nextIndex();
        clone.setInterceptors(this.interceptors.subList(next, this.interceptors.size()));
        return clone;
    }

    static /* synthetic */ Object[] access$302(InterceptorContext x0, Object[] x1) {
        x0.parameters = x1;
        return x1;
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVES = map;
    }

    private class Invocation
    implements InvocationContext {
        private Invocation() {
        }

        public Object getTarget() {
            return InterceptorContext.this.target;
        }

        public Method getMethod() {
            return InterceptorContext.this.method;
        }

        public Object[] getParameters() {
            if (InterceptorContext.this.parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.getParameters() in a lifecycle interceptor method");
            }
            return InterceptorContext.this.parameters;
        }

        public void setParameters(Object[] params) {
            if (InterceptorContext.this.parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.setParameters() in a lifecycle interceptor method");
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters must not be null");
            }
            if (InterceptorContext.this.method != null) {
                Class<?>[] parameterTypes = InterceptorContext.this.method.getParameterTypes();
                if (params.length != parameterTypes.length) {
                    throw new IllegalArgumentException("Number of parameters must match number of method arguments");
                }
                for (int i = 0; i < params.length; ++i) {
                    Class wrappedType;
                    Object param = params[i];
                    Class type = parameterTypes[i];
                    if (param == null) {
                        if (!type.isPrimitive()) continue;
                        throw new IllegalArgumentException("Null cannot be assigned to primitive parameter " + i + " (" + parameterTypes[i] + ")");
                    }
                    Class clazz = wrappedType = type.isPrimitive() ? (Class)PRIMITIVES.get(type) : type;
                    if (wrappedType.isAssignableFrom(param.getClass())) continue;
                    throw new IllegalArgumentException("Parameter " + i + " (" + param + ") is not assignable to method parameter type " + parameterTypes[i]);
                }
            }
            InterceptorContext.access$302(InterceptorContext.this, params);
        }

        public Map<String, Object> getContextData() {
            return InterceptorContext.this.contextData;
        }

        public Object getTimer() {
            return InterceptorContext.this.timer;
        }

        public Object proceed() throws Exception {
            return InterceptorContext.this.proceed();
        }

        public Constructor<?> getConstructor() {
            return InterceptorContext.this.constructor;
        }
    }
}

