/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.wildfly.common.function.ExceptionSupplier;

abstract class AbstractInterceptorContext {
    static final Map<Class<?>, Class<?>> PRIMITIVES;
    private final Map<Object, Object> privateData;
    private Object target;
    private Method method;
    private Constructor<?> constructor;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;
    private boolean blockingCaller = false;
    private ExceptionSupplier<Transaction, SystemException> transactionSupplier;

    AbstractInterceptorContext() {
        this.privateData = new IdentityHashMap<Object, Object>(4);
    }

    AbstractInterceptorContext(AbstractInterceptorContext interceptorContext, boolean copyData) {
        if (copyData) {
            this.privateData = new IdentityHashMap<Object, Object>(interceptorContext.privateData);
            this.contextData = new HashMap<String, Object>(interceptorContext.contextData);
        } else {
            this.privateData = interceptorContext.privateData;
            this.contextData = interceptorContext.contextData;
        }
        this.target = interceptorContext.target;
        this.method = interceptorContext.method;
        this.constructor = interceptorContext.constructor;
        this.parameters = interceptorContext.parameters;
        this.timer = interceptorContext.timer;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() throws IllegalStateException {
        Map<String, Object> contextData = this.contextData;
        if (contextData == null) {
            throw new IllegalStateException("The context data was not set");
        }
        return contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setTimer(Object timer) {
        this.timer = timer;
    }

    public boolean hasTransaction() {
        return this.transactionSupplier != null;
    }

    public Transaction getTransaction() throws SystemException {
        ExceptionSupplier<Transaction, SystemException> transactionSupplier = this.transactionSupplier;
        return transactionSupplier == null ? null : (Transaction)transactionSupplier.get();
    }

    public void setTransaction(Transaction transaction) {
        this.setTransactionSupplier((ExceptionSupplier<Transaction, SystemException>)(transaction == null ? null : () -> transaction));
    }

    public void setTransactionSupplier(ExceptionSupplier<Transaction, SystemException> transactionSupplier) {
        this.transactionSupplier = transactionSupplier;
    }

    public <T> T getPrivateData(Class<T> type) {
        return type.cast(this.privateData.get(type));
    }

    public Object getPrivateData(Object key) {
        return this.privateData.get(key);
    }

    public <T> T putPrivateData(Class<T> type, T value) {
        if (value == null) {
            return type.cast(this.privateData.remove(type));
        }
        return type.cast(this.privateData.put(type, type.cast(value)));
    }

    public Object putPrivateData(Object key, Object value) {
        if (key instanceof Class) {
            Class type = (Class)key;
            if (value == null) {
                return type.cast(this.privateData.remove(type));
            }
            return type.cast(this.privateData.put(type, type.cast(value)));
        }
        if (value == null) {
            return this.privateData.remove(key);
        }
        return this.privateData.put(key, value);
    }

    public boolean isBlockingCaller() {
        return this.blockingCaller;
    }

    public void setBlockingCaller(boolean blockingCaller) {
        this.blockingCaller = blockingCaller;
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVES = map;
    }
}

