/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.DefaultContext;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Context;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.api.SeverityLevelCounter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checker
extends AutomaticBean
implements MessageDispatcher {
    private final SeverityLevelCounter mCounter = new SeverityLevelCounter(SeverityLevel.ERROR);
    private final List<AuditListener> mListeners = Lists.newArrayList();
    private final List<FileSetCheck> mFileSetChecks = Lists.newArrayList();
    private ClassLoader mLoader = Thread.currentThread().getContextClassLoader();
    private String mBasedir;
    private String mLocaleCountry = Locale.getDefault().getCountry();
    private String mLocaleLanguage = Locale.getDefault().getLanguage();
    private ModuleFactory mModuleFactory;
    private ClassLoader mModuleClassLoader;
    private Context mChildContext;
    private final FilterSet mFilters = new FilterSet();
    private SeverityLevel mSeverityLevel = SeverityLevel.ERROR;
    private String mCharset = System.getProperty("file.encoding", "UTF-8");

    public Checker() throws CheckstyleException {
        this.addListener(this.mCounter);
    }

    @Override
    public void finishLocalSetup() throws CheckstyleException {
        Locale locale = new Locale(this.mLocaleLanguage, this.mLocaleCountry);
        LocalizedMessage.setLocale(locale);
        if (this.mModuleFactory == null) {
            if (this.mModuleClassLoader == null) {
                throw new CheckstyleException("if no custom moduleFactory is set, moduleClassLoader must be specified");
            }
            Set<String> packageNames = PackageNamesLoader.getPackageNames(this.mModuleClassLoader);
            this.mModuleFactory = new PackageObjectFactory(packageNames, this.mModuleClassLoader);
        }
        DefaultContext context = new DefaultContext();
        context.add("charset", this.mCharset);
        context.add("classLoader", this.mLoader);
        context.add("moduleFactory", this.mModuleFactory);
        context.add("severity", this.mSeverityLevel.getName());
        context.add("basedir", this.mBasedir);
        this.mChildContext = context;
    }

    @Override
    protected void setupChild(Configuration aChildConf) throws CheckstyleException {
        block6: {
            String name = aChildConf.getName();
            try {
                Object child = this.mModuleFactory.createModule(name);
                if (child instanceof AutomaticBean) {
                    AutomaticBean bean = (AutomaticBean)child;
                    bean.contextualize(this.mChildContext);
                    bean.configure(aChildConf);
                }
                if (child instanceof FileSetCheck) {
                    FileSetCheck fsc = (FileSetCheck)child;
                    this.addFileSetCheck(fsc);
                    break block6;
                }
                if (child instanceof Filter) {
                    Filter filter = (Filter)child;
                    this.addFilter(filter);
                    break block6;
                }
                if (child instanceof AuditListener) {
                    AuditListener listener = (AuditListener)child;
                    this.addListener(listener);
                    break block6;
                }
                throw new CheckstyleException(name + " is not allowed as a child in Checker");
            }
            catch (Exception ex) {
                throw new CheckstyleException("cannot initialize module " + name + " - " + ex.getMessage(), ex);
            }
        }
    }

    public void addFileSetCheck(FileSetCheck aFileSetCheck) {
        aFileSetCheck.setMessageDispatcher(this);
        this.mFileSetChecks.add(aFileSetCheck);
    }

    public void addFilter(Filter aFilter) {
        this.mFilters.addFilter(aFilter);
    }

    public void removeFilter(Filter aFilter) {
        this.mFilters.removeFilter(aFilter);
    }

    public void destroy() {
        this.mListeners.clear();
        this.mFilters.clear();
    }

    public void addListener(AuditListener aListener) {
        this.mListeners.add(aListener);
    }

    public void removeListener(AuditListener aListener) {
        this.mListeners.remove(aListener);
    }

    public int process(List<File> aFiles) {
        this.fireAuditStarted();
        for (FileSetCheck fsc : this.mFileSetChecks) {
            fsc.beginProcessing(this.mCharset);
        }
        for (File f : aFiles) {
            String fileName = f.getAbsolutePath();
            this.fireFileStarted(fileName);
            TreeSet fileMessages = Sets.newTreeSet();
            try {
                Object[] lines = Utils.getLines(f.getAbsolutePath(), this.mCharset);
                ArrayList theLines = Lists.newArrayList((Object[])lines);
                for (FileSetCheck fsc : this.mFileSetChecks) {
                    fileMessages.addAll(fsc.process(f, theLines));
                }
            }
            catch (FileNotFoundException fnfe) {
                Utils.getExceptionLogger().debug((Object)"FileNotFoundException occured.", (Throwable)fnfe);
                fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.fileNotFound", null, null, this.getClass(), null));
            }
            catch (IOException ioe) {
                Utils.getExceptionLogger().debug((Object)"IOException occured.", (Throwable)ioe);
                fileMessages.add(new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", "general.exception", new String[]{ioe.getMessage()}, null, this.getClass(), null));
            }
            this.fireErrors(fileName, fileMessages);
            this.fireFileFinished(fileName);
        }
        for (FileSetCheck fsc : this.mFileSetChecks) {
            fsc.finishProcessing();
            fsc.destroy();
        }
        int errorCount = this.mCounter.getCount();
        this.fireAuditFinished();
        return errorCount;
    }

    private String getStrippedFileName(String aFileName) {
        return Utils.getStrippedFileName(this.mBasedir, aFileName);
    }

    public void setBasedir(String aBasedir) {
        this.mBasedir = this.normalize(aBasedir);
    }

    public String normalize(String aPath) {
        int i;
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean onNetWare = osName.indexOf("netware") > -1;
        String orig = aPath;
        aPath = aPath.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        int colon = aPath.indexOf(":");
        if (!onNetWare) {
            if (!(aPath.startsWith(File.separator) || aPath.length() >= 2 && Character.isLetter(aPath.charAt(0)) && colon == 1)) {
                String msg = aPath + " is not an absolute path";
                throw new IllegalArgumentException(msg);
            }
        } else if (!aPath.startsWith(File.separator) && colon == -1) {
            String msg = aPath + " is not an absolute path";
            throw new IllegalArgumentException(msg);
        }
        boolean dosWithDrive = false;
        String root = null;
        if (!onNetWare && aPath.length() >= 2 && Character.isLetter(aPath.charAt(0)) && aPath.charAt(1) == ':' || onNetWare && colon > -1) {
            dosWithDrive = true;
            char[] ca = aPath.replace('/', '\\').toCharArray();
            StringBuffer sbRoot = new StringBuffer();
            for (int i2 = 0; i2 < colon; ++i2) {
                sbRoot.append(Character.toUpperCase(ca[i2]));
            }
            sbRoot.append(':');
            if (colon + 1 < aPath.length()) {
                sbRoot.append(File.separatorChar);
            }
            root = sbRoot.toString();
            StringBuffer sbPath = new StringBuffer();
            for (i = colon + 1; i < ca.length; ++i) {
                if (ca[i] == '\\' && (ca[i] != '\\' || ca[i - 1] == '\\')) continue;
                sbPath.append(ca[i]);
            }
            aPath = sbPath.toString().replace('\\', File.separatorChar);
        } else if (aPath.length() == 1) {
            root = File.separator;
            aPath = "";
        } else if (aPath.charAt(1) == File.separatorChar) {
            root = File.separator + File.separator;
            aPath = aPath.substring(2);
        } else {
            root = File.separator;
            aPath = aPath.substring(1);
        }
        FastStack s = FastStack.newInstance();
        s.push(root);
        StringTokenizer tok = new StringTokenizer(aPath, File.separator);
        while (tok.hasMoreTokens()) {
            String thisToken = tok.nextToken();
            if (".".equals(thisToken)) continue;
            if ("..".equals(thisToken)) {
                if (s.size() < 2) {
                    throw new IllegalArgumentException("Cannot resolve path " + orig);
                }
                s.pop();
                continue;
            }
            s.push(thisToken);
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < s.size(); ++i) {
            if (i > 1) {
                sb.append(File.separatorChar);
            }
            sb.append((String)s.peek(i));
        }
        aPath = sb.toString();
        if (dosWithDrive) {
            aPath = aPath.replace('/', '\\');
        }
        return aPath;
    }

    public final String getBasedir() {
        return this.mBasedir;
    }

    protected void fireAuditStarted() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.mListeners) {
            listener.auditStarted(evt);
        }
    }

    protected void fireAuditFinished() {
        AuditEvent evt = new AuditEvent(this);
        for (AuditListener listener : this.mListeners) {
            listener.auditFinished(evt);
        }
    }

    @Override
    public void fireFileStarted(String aFileName) {
        String stripped = this.getStrippedFileName(aFileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.mListeners) {
            listener.fileStarted(evt);
        }
    }

    @Override
    public void fireFileFinished(String aFileName) {
        String stripped = this.getStrippedFileName(aFileName);
        AuditEvent evt = new AuditEvent(this, stripped);
        for (AuditListener listener : this.mListeners) {
            listener.fileFinished(evt);
        }
    }

    @Override
    public void fireErrors(String aFileName, TreeSet<LocalizedMessage> aErrors) {
        String stripped = this.getStrippedFileName(aFileName);
        for (LocalizedMessage element : aErrors) {
            AuditEvent evt = new AuditEvent(this, stripped, element);
            if (!this.mFilters.accept(evt)) continue;
            for (AuditListener listener : this.mListeners) {
                listener.addError(evt);
            }
        }
    }

    public void setModuleFactory(ModuleFactory aModuleFactory) {
        this.mModuleFactory = aModuleFactory;
    }

    public void setLocaleCountry(String aLocaleCountry) {
        this.mLocaleCountry = aLocaleCountry;
    }

    public void setLocaleLanguage(String aLocaleLanguage) {
        this.mLocaleLanguage = aLocaleLanguage;
    }

    public final void setSeverity(String aSeverity) {
        this.mSeverityLevel = SeverityLevel.getInstance(aSeverity);
    }

    public final void setClassloader(ClassLoader aLoader) {
        this.mLoader = aLoader;
    }

    public final void setModuleClassLoader(ClassLoader aModuleClassLoader) {
        this.mModuleClassLoader = aModuleClassLoader;
    }

    public void setCharset(String aCharset) throws UnsupportedEncodingException {
        if (!Charset.isSupported(aCharset)) {
            String message = "unsupported charset: '" + aCharset + "'";
            throw new UnsupportedEncodingException(message);
        }
        this.mCharset = aCharset;
    }
}

