/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.AnalysisCacheToRepositoryAdapter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationRetentionDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.INullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.jsr305.DirectlyRelevantTypeQualifiersDatabase;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.ReturnValueNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisCacheToAnalysisContextAdapter
extends AnalysisContext {
    private RepositoryLookupFailureCallback lookupFailureCallback = new DelegatingRepositoryLookupFailureCallback();
    private TypeQualifierNullnessAnnotationDatabase tqNullnessDatabase;

    @Override
    public void addClasspathEntry(String url) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearClassContextCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearRepository() {
        Repository.setRepository(new AnalysisCacheToRepositoryAdapter());
    }

    @Override
    public AnnotationRetentionDatabase getAnnotationRetentionDatabase() {
        return this.getDatabase(AnnotationRetentionDatabase.class);
    }

    @Override
    public CheckReturnAnnotationDatabase getCheckReturnAnnotationDatabase() {
        return this.getDatabase(CheckReturnAnnotationDatabase.class);
    }

    @Override
    public ClassContext getClassContext(JavaClass javaClass) {
        ClassDescriptor classDescriptor = DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(javaClass.getClassName()));
        try {
            return Global.getAnalysisCache().getClassAnalysis(ClassContext.class, classDescriptor);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("Could not get ClassContext for JavaClass");
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public String getClassContextStats() {
        return "<unknown ClassContext stats>";
    }

    @Override
    public FieldStoreTypeDatabase getFieldStoreTypeDatabase() {
        return this.getDatabase(FieldStoreTypeDatabase.class);
    }

    @Override
    public JCIPAnnotationDatabase getJCIPAnnotationDatabase() {
        return this.getDatabase(JCIPAnnotationDatabase.class);
    }

    @Override
    public RepositoryLookupFailureCallback getLookupFailureCallback() {
        return this.lookupFailureCallback;
    }

    @Override
    public INullnessAnnotationDatabase getNullnessAnnotationDatabase() {
        if (this.tqNullnessDatabase == null) {
            this.tqNullnessDatabase = new TypeQualifierNullnessAnnotationDatabase();
        }
        return this.tqNullnessDatabase;
    }

    @Override
    public SourceFinder getSourceFinder() {
        return this.project.getSourceFinder();
    }

    @Override
    public SourceInfoMap getSourceInfoMap() {
        return this.getDatabase(SourceInfoMap.class);
    }

    @Override
    public ParameterNullnessPropertyDatabase getUnconditionalDerefParamDatabase() {
        return this.getDatabase(ParameterNullnessPropertyDatabase.class);
    }

    @Override
    public void initDatabases() {
    }

    @Override
    public JavaClass lookupClass(@DottedClassName String className) throws ClassNotFoundException {
        try {
            if (className.length() == 0) {
                throw new IllegalArgumentException("Class name is empty");
            }
            if (!ClassName.isValidClassName(className)) {
                throw new ClassNotFoundException("Invalid class name: " + className);
            }
            return Global.getAnalysisCache().getClassAnalysis(JavaClass.class, DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(className)));
        }
        catch (CheckedAnalysisException e) {
            throw new ClassNotFoundException("Class not found: " + className, e);
        }
    }

    @Override
    public InnerClassAccessMap getInnerClassAccessMap() {
        return this.getDatabase(InnerClassAccessMap.class);
    }

    private <E> E getDatabase(Class<E> cls) {
        return Global.getAnalysisCache().getDatabase(cls);
    }

    public void setAppClassList(List<ClassDescriptor> appClassCollection) throws CheckedAnalysisException {
        HashSet<ClassDescriptor> appSet = new HashSet<ClassDescriptor>(appClassCollection);
        ArrayList<ClassDescriptor> allClassDescriptors = new ArrayList<ClassDescriptor>(DescriptorFactory.instance().getAllClassDescriptors());
        for (ClassDescriptor appClass : allClassDescriptors) {
            try {
                XClass xclass = AnalysisCacheToAnalysisContextAdapter.currentXFactory().getXClass(appClass);
                if (xclass == null) continue;
                if (appSet.contains(appClass)) {
                    this.getSubtypes2().addApplicationClass(xclass);
                    continue;
                }
                if (!(xclass instanceof ClassInfo)) continue;
                this.getSubtypes2().addClass(xclass);
            }
            catch (Exception e) {
                AnalysisContext.logError("Unable to get XClass for " + appClass, e);
            }
        }
        if (Subtypes2.DEBUG) {
            System.out.println(this.getSubtypes2().getGraph().getNumVertices() + " vertices in inheritance graph");
        }
    }

    @Override
    public void updateDatabases(int pass) {
        if (pass == 0) {
            this.getCheckReturnAnnotationDatabase().loadAuxiliaryAnnotations();
            this.getNullnessAnnotationDatabase().loadAuxiliaryAnnotations();
        }
    }

    @Override
    public ReturnValueNullnessPropertyDatabase getReturnValueNullnessPropertyDatabase() {
        return this.getDatabase(ReturnValueNullnessPropertyDatabase.class);
    }

    @Override
    public Subtypes2 getSubtypes2() {
        return Global.getAnalysisCache().getDatabase(Subtypes2.class);
    }

    @Override
    public DirectlyRelevantTypeQualifiersDatabase getDirectlyRelevantTypeQualifiersDatabase() {
        return Global.getAnalysisCache().getDatabase(DirectlyRelevantTypeQualifiersDatabase.class);
    }

    static class DelegatingRepositoryLookupFailureCallback
    implements RepositoryLookupFailureCallback {
        DelegatingRepositoryLookupFailureCallback() {
        }

        public void logError(String message) {
            Global.getAnalysisCache().getErrorLogger().logError(message);
        }

        public void logError(String message, Throwable e) {
            Global.getAnalysisCache().getErrorLogger().logError(message, e);
        }

        public void reportMissingClass(ClassNotFoundException ex) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(ex);
        }

        public void reportMissingClass(ClassDescriptor classDescriptor) {
            Global.getAnalysisCache().getErrorLogger().reportMissingClass(classDescriptor);
        }

        public void reportSkippedAnalysis(MethodDescriptor method) {
            Global.getAnalysisCache().getErrorLogger().reportSkippedAnalysis(method);
        }
    }
}

