/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.classfile.FieldOrMethodDescriptor;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.WillClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDatabase<KeyType extends FieldOrMethodDescriptor, ValueType> {
    private Map<KeyType, ValueType> propertyMap = new HashMap<KeyType, ValueType>();

    protected PropertyDatabase() {
    }

    public void setProperty(KeyType key, ValueType property) {
        this.propertyMap.put(key, property);
    }

    public ValueType getProperty(KeyType key) {
        return this.propertyMap.get(key);
    }

    public Set<KeyType> getKeys() {
        return this.propertyMap.keySet();
    }

    public Collection<Map.Entry<KeyType, ValueType>> entrySet() {
        return this.propertyMap.entrySet();
    }

    public boolean isEmpty() {
        return this.propertyMap.isEmpty();
    }

    public ValueType removeProperty(KeyType key) {
        return this.propertyMap.remove(key);
    }

    public void readFromFile(String fileName) throws IOException, PropertyDatabaseFormatException {
        this.read(new FileInputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(@WillClose InputStream in) throws IOException, PropertyDatabaseFormatException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(Util.getReader(in));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                int bar = line.indexOf(124);
                if (bar < 0) {
                    throw new PropertyDatabaseFormatException("Invalid property database: missing separator");
                }
                KeyType key = this.parseKey(line.substring(0, bar));
                ValueType property = this.decodeProperty(line.substring(bar + 1));
                this.setProperty(key, property);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void writeToFile(String fileName) throws IOException {
        this.write(new FileOutputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@WillClose OutputStream out) throws IOException {
        BufferedWriter writer = null;
        boolean missingClassWarningsSuppressed = AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(true);
        try {
            writer = new BufferedWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")));
            TreeSet<KeyType> sortedMethodSet = new TreeSet<KeyType>();
            sortedMethodSet.addAll(this.propertyMap.keySet());
            for (FieldOrMethodDescriptor key : sortedMethodSet) {
                if (!AnalysisContext.currentAnalysisContext().isApplicationClass(key.getClassDescriptor())) continue;
                ValueType property = this.propertyMap.get(key);
                this.writeKey(writer, key);
                writer.write("|");
                writer.write(this.encodeProperty(property));
                writer.write("\n");
            }
        }
        finally {
            AnalysisContext.currentAnalysisContext().setMissingClassWarningsSuppressed(missingClassWarningsSuppressed);
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    protected abstract KeyType parseKey(String var1) throws PropertyDatabaseFormatException;

    protected abstract void writeKey(Writer var1, KeyType var2) throws IOException;

    protected abstract ValueType decodeProperty(String var1) throws PropertyDatabaseFormatException;

    protected abstract String encodeProperty(ValueType var1);
}

