/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.Analyze;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericSignatureParser;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.type.ExceptionObjectType;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.StandardTypeMerger;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.type.TypeFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAnalysis
extends FrameDataflowAnalysis<Type, TypeFrame>
implements EdgeTypes {
    public static final boolean DEBUG = SystemProperties.getBoolean("ta.debug");
    public static final boolean FORCE_ACCURATE_EXCEPTIONS = SystemProperties.getBoolean("ta.accurateExceptions");
    protected MethodGen methodGen;
    private final Method method;
    protected CFG cfg;
    private TypeMerger typeMerger;
    private TypeFrameModelingVisitor visitor;
    private LocalVariableTypeTable typeTable;
    private BitSet startOfLocalTypedVariables = new BitSet();
    private Map<BasicBlock, CachedExceptionSet> thrownExceptionSetMap;
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private ExceptionSetFactory exceptionSetFactory;
    private ValueNumberDataflow valueNumberDataflow;
    private Map<BasicBlock, InstanceOfCheck> instanceOfCheckMap;

    public TypeAnalysis(Method method, MethodGen methodGen, CFG cfg, DepthFirstSearch dfs, TypeMerger typeMerger, TypeFrameModelingVisitor visitor, RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
        super(dfs);
        this.method = method;
        Code code = method.getCode();
        if (code == null) {
            throw new IllegalArgumentException(method.getName() + " has no code");
        }
        for (Attribute a : code.getAttributes()) {
            if (!(a instanceof LocalVariableTypeTable)) continue;
            this.typeTable = (LocalVariableTypeTable)a;
            for (LocalVariable v : this.typeTable.getLocalVariableTable()) {
                int startPC = v.getStartPC();
                if (startPC < 0) continue;
                this.startOfLocalTypedVariables.set(startPC);
            }
        }
        this.methodGen = methodGen;
        this.cfg = cfg;
        this.typeMerger = typeMerger;
        this.visitor = visitor;
        this.thrownExceptionSetMap = new HashMap<BasicBlock, CachedExceptionSet>();
        this.lookupFailureCallback = lookupFailureCallback;
        this.exceptionSetFactory = exceptionSetFactory;
        this.instanceOfCheckMap = new HashMap<BasicBlock, InstanceOfCheck>();
        if (DEBUG) {
            System.out.println("\n\nAnalyzing " + methodGen);
        }
    }

    public TypeAnalysis(Method method, MethodGen methodGen, CFG cfg, DepthFirstSearch dfs, TypeMerger typeMerger, RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
        this(method, methodGen, cfg, dfs, typeMerger, new TypeFrameModelingVisitor(methodGen.getConstantPool()), lookupFailureCallback, exceptionSetFactory);
    }

    public TypeAnalysis(Method method, MethodGen methodGen, CFG cfg, DepthFirstSearch dfs, RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
        this(method, methodGen, cfg, dfs, new StandardTypeMerger(lookupFailureCallback, exceptionSetFactory), lookupFailureCallback, exceptionSetFactory);
    }

    public void setValueNumberDataflow(ValueNumberDataflow valueNumberDataflow) {
        this.valueNumberDataflow = valueNumberDataflow;
        this.visitor.setValueNumberDataflow(valueNumberDataflow);
    }

    public void setFieldStoreTypeDatabase(FieldStoreTypeDatabase database) {
        this.visitor.setFieldStoreTypeDatabase(database);
    }

    public ExceptionSet getEdgeExceptionSet(Edge edge) {
        CachedExceptionSet cachedExceptionSet = this.thrownExceptionSetMap.get(edge.getSource());
        return cachedExceptionSet.getEdgeExceptionSet(edge);
    }

    @Override
    public TypeFrame createFact() {
        return new TypeFrame(this.methodGen.getMaxLocals());
    }

    @Override
    public void initEntryFact(TypeFrame result) {
        Type[] argumentTypes;
        result.setValid();
        int slot = 0;
        result.clearStack();
        if (!this.methodGen.isStatic()) {
            result.setValue(slot++, ObjectTypeFactory.getInstance(this.methodGen.getClassName()));
        }
        Iterator<String> iter = GenericSignatureParser.getGenericSignatureIterator(this.method);
        for (Type argType : argumentTypes = this.methodGen.getArgumentTypes()) {
            String s;
            if (argType.getType() == 11) {
                result.setValue(slot++, TypeFrame.getLongExtraType());
            } else if (argType.getType() == 7) {
                result.setValue(slot++, TypeFrame.getDoubleExtraType());
            }
            String string = s = iter == null || !iter.hasNext() ? null : iter.next();
            if (s != null && (argType instanceof ObjectType || argType instanceof ArrayType) && !(argType instanceof ExceptionObjectType)) {
                try {
                    argType = GenericUtilities.getType(s);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
            }
            result.setValue(slot++, argType);
        }
        while (slot < this.methodGen.getMaxLocals()) {
            result.setValue(slot++, TypeFrame.getBottomType());
        }
    }

    @Override
    public void copy(TypeFrame source, TypeFrame dest) {
        dest.copyFrom(source);
    }

    @Override
    public void makeFactTop(TypeFrame fact) {
        fact.setTop();
    }

    @Override
    public boolean isFactValid(TypeFrame fact) {
        return fact.isValid();
    }

    @Override
    public boolean same(TypeFrame fact1, TypeFrame fact2) {
        return fact1.sameAs(fact2);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, TypeFrame fact) throws DataflowAnalysisException {
        int pos;
        if (this.typeTable != null && (pos = handle.getPosition()) >= 0 && this.startOfLocalTypedVariables.get(pos)) {
            for (LocalVariable local : this.typeTable.getLocalVariableTable()) {
                int index;
                Type currentValue;
                Type t;
                if (local.getStartPC() != pos) continue;
                String signature = local.getSignature();
                try {
                    t = GenericUtilities.getType(signature);
                }
                catch (RuntimeException e) {
                    AnalysisContext.logError("Bad signature " + signature + " for " + local.getName() + " in " + this.methodGen.getClassName() + "." + this.method.getName(), e);
                    continue;
                }
                if (!(t instanceof GenericObjectType) || (currentValue = (Type)fact.getValue(index = local.getIndex())) instanceof GenericObjectType || !(currentValue instanceof ObjectType)) continue;
                fact.setValue(index, GenericUtilities.merge((GenericObjectType)t, (ObjectType)currentValue));
            }
        }
        this.visitor.setFrameAndLocation(fact, new Location(handle, basicBlock));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, TypeFrame start, TypeFrame result) throws DataflowAnalysisException {
        this.visitor.startBasicBlock();
        super.transfer(basicBlock, end, start, result);
        this.computeThrownExceptionTypes(basicBlock, end, result);
        if (DEBUG) {
            System.out.println("After " + basicBlock.getFirstInstruction() + " -> " + basicBlock.getLastInstruction());
            System.out.println("    frame: " + result);
        }
        this.instanceOfCheckMap.remove(basicBlock);
        if (this.visitor.isInstanceOfFollowedByBranch()) {
            InstanceOfCheck check = new InstanceOfCheck(this.visitor.getInstanceOfValueNumber(), this.visitor.getInstanceOfType());
            this.instanceOfCheckMap.put(basicBlock, check);
        }
    }

    private void computeThrownExceptionTypes(BasicBlock basicBlock, @CheckForNull InstructionHandle end, TypeFrame result) throws DataflowAnalysisException {
        if (!FORCE_ACCURATE_EXCEPTIONS && !AnalysisContext.currentAnalysisContext().getBoolProperty(0)) {
            return;
        }
        if (!basicBlock.isExceptionThrower()) {
            return;
        }
        CachedExceptionSet cachedExceptionSet = this.getCachedExceptionSet(basicBlock);
        if (cachedExceptionSet.isUpToDate(result)) {
            return;
        }
        int exceptionEdgeCount = 0;
        Edge lastExceptionEdge = null;
        Iterator i = this.cfg.outgoingEdgeIterator(basicBlock);
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            if (!e.isExceptionEdge()) continue;
            ++exceptionEdgeCount;
            lastExceptionEdge = e;
        }
        if (exceptionEdgeCount == 0) {
            return;
        }
        cachedExceptionSet = this.computeBlockExceptionSet(basicBlock, result);
        if (exceptionEdgeCount == 1) {
            cachedExceptionSet.setEdgeExceptionSet(lastExceptionEdge, cachedExceptionSet.getExceptionSet());
            return;
        }
        ExceptionSet thrownExceptionSet = cachedExceptionSet.getExceptionSet();
        if (!thrownExceptionSet.isEmpty()) {
            thrownExceptionSet = thrownExceptionSet.duplicate();
        }
        Iterator i2 = this.cfg.outgoingEdgeIterator(basicBlock);
        while (i2.hasNext()) {
            Edge edge = (Edge)i2.next();
            if (!edge.isExceptionEdge()) continue;
            cachedExceptionSet.setEdgeExceptionSet(edge, this.computeEdgeExceptionSet(edge, thrownExceptionSet));
        }
    }

    @Override
    public void meetInto(TypeFrame fact, Edge edge, TypeFrame result) throws DataflowAnalysisException {
        BasicBlock basicBlock = (BasicBlock)edge.getTarget();
        if (fact.isValid()) {
            TypeFrame tmpFact = null;
            if (basicBlock.isExceptionHandler()) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                CodeExceptionGen exceptionGen = basicBlock.getExceptionGen();
                tmpFact.clearStack();
                Type catchType = null;
                if (FORCE_ACCURATE_EXCEPTIONS || AnalysisContext.currentAnalysisContext().getBoolProperty(0)) {
                    try {
                        CachedExceptionSet cachedExceptionSet = this.getCachedExceptionSet((BasicBlock)edge.getSource());
                        ExceptionSet edgeExceptionSet = cachedExceptionSet.getEdgeExceptionSet(edge);
                        if (!edgeExceptionSet.isEmpty()) {
                            catchType = ExceptionObjectType.fromExceptionSet(edgeExceptionSet);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        this.lookupFailureCallback.reportMissingClass(e);
                    }
                }
                if (catchType == null && (catchType = exceptionGen.getCatchType()) == null) {
                    catchType = Type.THROWABLE;
                }
                tmpFact.pushValue(catchType);
            }
            if (this.valueNumberDataflow != null) {
                tmpFact = this.handleInstanceOfBranch(fact, tmpFact, edge);
            }
            if (tmpFact != null) {
                fact = tmpFact;
            }
        }
        this.mergeInto(fact, result);
    }

    private TypeFrame handleInstanceOfBranch(TypeFrame fact, TypeFrame tmpFact, Edge edge) throws DataflowAnalysisException {
        block13: {
            int numSlots;
            Type instanceOfType;
            ValueNumberFrame vnaFrame;
            ValueNumber instanceOfValueNumber;
            block12: {
                InstanceOfCheck check = this.instanceOfCheckMap.get(edge.getSource());
                if (check == null) {
                    return tmpFact;
                }
                if (check.getValueNumber() == null) {
                    return tmpFact;
                }
                instanceOfValueNumber = check.getValueNumber();
                vnaFrame = (ValueNumberFrame)this.valueNumberDataflow.getStartFact((BasicBlock)edge.getTarget());
                if (!vnaFrame.isValid()) {
                    return tmpFact;
                }
                instanceOfType = check.getType();
                if (!(instanceOfType instanceof ReferenceType) && !(instanceOfType instanceof NullType)) {
                    return tmpFact;
                }
                short branchOpcode = ((BasicBlock)edge.getSource()).getLastInstruction().getInstruction().getOpcode();
                int edgeType = edge.getType();
                numSlots = Math.min(fact.getNumSlots(), vnaFrame.getNumSlots());
                if ((edgeType != 1 || branchOpcode != 154 && branchOpcode != 157 && branchOpcode != 198) && (edgeType != 0 || branchOpcode != 153 && branchOpcode != 158 && branchOpcode != 199)) break block12;
                for (int i = 0; i < numSlots; ++i) {
                    Type checkedType;
                    if (!((ValueNumber)vnaFrame.getValue(i)).equals(instanceOfValueNumber) || !((checkedType = (Type)fact.getValue(i)) instanceof ReferenceType)) continue;
                    try {
                        double v;
                        boolean feasibleCheck;
                        boolean guaranteed = Hierarchy.isSubtype((ReferenceType)checkedType, (ReferenceType)instanceOfType);
                        if (guaranteed) continue;
                        boolean bl = feasibleCheck = instanceOfType.equals(NullType.instance()) || Hierarchy.isSubtype((ReferenceType)instanceOfType, (ReferenceType)checkedType);
                        if (!feasibleCheck && instanceOfType instanceof ObjectType && checkedType instanceof ObjectType && (v = Analyze.deepInstanceOf(((ObjectType)instanceOfType).getClassName(), ((ObjectType)checkedType).getClassName())) > 0.0) {
                            feasibleCheck = true;
                        }
                        tmpFact = this.modifyFrame(fact, tmpFact);
                        if (feasibleCheck) {
                            tmpFact.setValue(i, instanceOfType);
                            continue;
                        }
                        tmpFact.setTop();
                        return tmpFact;
                    }
                    catch (ClassNotFoundException e) {
                        this.lookupFailureCallback.reportMissingClass(e);
                        return tmpFact;
                    }
                }
                break block13;
            }
            if (instanceOfType.equals(NullType.instance())) break block13;
            for (int i = 0; i < numSlots; ++i) {
                Type checkedType;
                if (!((ValueNumber)vnaFrame.getValue(i)).equals(instanceOfValueNumber) || !((checkedType = (Type)fact.getValue(i)) instanceof ReferenceType)) continue;
                try {
                    boolean guaranteed = Hierarchy.isSubtype((ReferenceType)checkedType, (ReferenceType)instanceOfType);
                    if (!guaranteed) continue;
                    tmpFact = this.modifyFrame(fact, tmpFact);
                    tmpFact.setTop();
                    return tmpFact;
                }
                catch (ClassNotFoundException e) {
                    this.lookupFailureCallback.reportMissingClass(e);
                    return tmpFact;
                }
            }
        }
        return tmpFact;
    }

    @Override
    protected void mergeValues(TypeFrame otherFrame, TypeFrame resultFrame, int slot) throws DataflowAnalysisException {
        Type type2 = (Type)resultFrame.getValue(slot);
        Type type1 = (Type)otherFrame.getValue(slot);
        Type value = this.typeMerger.mergeTypes(type2, type1);
        resultFrame.setValue(slot, value);
        boolean typesAreIdentical = type1.equals(type2);
        boolean bothExact = resultFrame.isExact(slot) && otherFrame.isExact(slot);
        resultFrame.setExact(slot, typesAreIdentical && bothExact);
    }

    private CachedExceptionSet getCachedExceptionSet(BasicBlock basicBlock) {
        CachedExceptionSet cachedExceptionSet = this.thrownExceptionSetMap.get(basicBlock);
        if (cachedExceptionSet == null) {
            TypeFrame top = this.createFact();
            this.makeFactTop(top);
            cachedExceptionSet = new CachedExceptionSet(top, this.exceptionSetFactory.createExceptionSet());
            this.thrownExceptionSetMap.put(basicBlock, cachedExceptionSet);
        }
        return cachedExceptionSet;
    }

    private CachedExceptionSet computeBlockExceptionSet(BasicBlock basicBlock, TypeFrame result) throws DataflowAnalysisException {
        ExceptionSet exceptionSet;
        try {
            exceptionSet = this.computeThrownExceptionTypes(basicBlock);
        }
        catch (ClassNotFoundException e) {
            this.lookupFailureCallback.reportMissingClass(e);
            exceptionSet = this.exceptionSetFactory.createExceptionSet();
            exceptionSet.addExplicit(Type.THROWABLE);
        }
        TypeFrame copyOfResult = this.createFact();
        this.copy(result, copyOfResult);
        CachedExceptionSet cachedExceptionSet = new CachedExceptionSet(copyOfResult, exceptionSet);
        this.thrownExceptionSetMap.put(basicBlock, cachedExceptionSet);
        return cachedExceptionSet;
    }

    private ExceptionSet computeEdgeExceptionSet(Edge edge, ExceptionSet thrownExceptionSet) {
        if (thrownExceptionSet.isEmpty()) {
            return thrownExceptionSet;
        }
        ExceptionSet result = this.exceptionSetFactory.createExceptionSet();
        if (edge.getType() == 8) {
            result.addAll(thrownExceptionSet);
            thrownExceptionSet.clear();
            return result;
        }
        BasicBlock handlerBlock = (BasicBlock)edge.getTarget();
        CodeExceptionGen handler = handlerBlock.getExceptionGen();
        ObjectType catchType = handler.getCatchType();
        if (Hierarchy.isUniversalExceptionHandler(catchType)) {
            result.addAll(thrownExceptionSet);
            thrownExceptionSet.clear();
        } else {
            ExceptionSet.ThrownExceptionIterator i = thrownExceptionSet.iterator();
            while (i.hasNext()) {
                ObjectType thrownType = i.next();
                boolean explicit = i.isExplicit();
                if (DEBUG) {
                    System.out.println("\texception type " + thrownType + ", catch type " + catchType);
                }
                try {
                    if (Hierarchy.isSubtype(thrownType, catchType)) {
                        result.add(thrownType, explicit);
                        i.remove();
                        if (!DEBUG) continue;
                        System.out.println("\tException is subtype of catch type: will definitely catch");
                        continue;
                    }
                    if (!Hierarchy.isSubtype(catchType, thrownType)) continue;
                    result.add(thrownType, explicit);
                    if (!DEBUG) continue;
                    System.out.println("\tException is supertype of catch type: might catch");
                }
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                    result.add(thrownType, explicit);
                }
            }
        }
        return result;
    }

    private ExceptionSet computeThrownExceptionTypes(BasicBlock basicBlock) throws ClassNotFoundException, DataflowAnalysisException {
        Class[] exceptionList;
        ExceptionSet exceptionTypeSet = this.exceptionSetFactory.createExceptionSet();
        InstructionHandle pei = basicBlock.getExceptionThrower();
        Instruction ins = pei.getInstruction();
        ExceptionThrower exceptionThrower = (ExceptionThrower)((Object)ins);
        for (Class aExceptionList : exceptionList = exceptionThrower.getExceptions()) {
            exceptionTypeSet.addImplicit(ObjectTypeFactory.getInstance(aExceptionList.getName()));
        }
        exceptionTypeSet.addImplicit(Hierarchy.ERROR_TYPE);
        if (ins instanceof ATHROW && basicBlock.containsInstruction(pei)) {
            exceptionTypeSet.clear();
            TypeFrame frame = (TypeFrame)this.getStartFact(basicBlock);
            if (!frame.isValid()) {
                exceptionTypeSet.addExplicit(Type.THROWABLE);
            } else {
                if (frame.getStackDepth() == 0) {
                    throw new IllegalStateException("empty stack  thrown by " + pei + " in " + SignatureConverter.convertMethodSignature(this.methodGen));
                }
                Type throwType = (Type)frame.getTopValue();
                if (throwType instanceof ObjectType) {
                    exceptionTypeSet.addExplicit((ObjectType)throwType);
                } else if (throwType instanceof ExceptionObjectType) {
                    exceptionTypeSet.addAll(((ExceptionObjectType)throwType).getExceptionSet());
                } else {
                    if (DEBUG) {
                        System.out.println("Non object type " + throwType + " thrown by " + pei + " in " + SignatureConverter.convertMethodSignature(this.methodGen));
                    }
                    exceptionTypeSet.addExplicit(Type.THROWABLE);
                }
            }
        }
        if (ins instanceof InvokeInstruction) {
            InvokeInstruction inv = (InvokeInstruction)ins;
            ConstantPoolGen cpg = this.methodGen.getConstantPool();
            ObjectType[] declaredExceptionList = Hierarchy2.findDeclaredExceptions(inv, cpg);
            if (declaredExceptionList == null) {
                if (DEBUG) {
                    System.out.println("Couldn't find declared exceptions for " + SignatureConverter.convertMethodSignature(inv, cpg));
                }
                exceptionTypeSet.addExplicit(Hierarchy.EXCEPTION_TYPE);
            } else {
                for (ObjectType aDeclaredExceptionList : declaredExceptionList) {
                    exceptionTypeSet.addExplicit(aDeclaredExceptionList);
                }
            }
            exceptionTypeSet.addImplicit(Hierarchy.RUNTIME_EXCEPTION_TYPE);
        }
        if (DEBUG) {
            System.out.println(pei + " can throw " + exceptionTypeSet);
        }
        return exceptionTypeSet;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.methodGen.getClassName() + "." + this.methodGen.getMethod().getName() + this.methodGen.getMethod().getSignature() + ")";
    }

    public boolean isImpliedByGenericTypes(ReferenceType t) {
        return this.visitor.isImpliedByGenericTypes(t);
    }

    static class InstanceOfCheck {
        final ValueNumber valueNumber;
        final Type type;

        InstanceOfCheck(ValueNumber valueNumber, Type type) {
            this.valueNumber = valueNumber;
            this.type = type;
        }

        public ValueNumber getValueNumber() {
            return this.valueNumber;
        }

        public Type getType() {
            return this.type;
        }
    }

    private class CachedExceptionSet {
        private TypeFrame result;
        private ExceptionSet exceptionSet;
        private Map<Edge, ExceptionSet> edgeExceptionMap;

        public CachedExceptionSet(TypeFrame result, ExceptionSet exceptionSet) {
            this.result = result;
            this.exceptionSet = exceptionSet;
            this.edgeExceptionMap = new HashMap<Edge, ExceptionSet>();
        }

        public boolean isUpToDate(TypeFrame result) {
            return this.result.equals(result);
        }

        public ExceptionSet getExceptionSet() {
            return this.exceptionSet;
        }

        public void setEdgeExceptionSet(Edge edge, ExceptionSet exceptionSet) {
            this.edgeExceptionMap.put(edge, exceptionSet);
        }

        public ExceptionSet getEdgeExceptionSet(Edge edge) {
            ExceptionSet edgeExceptionSet = this.edgeExceptionMap.get(edge);
            if (edgeExceptionSet == null) {
                edgeExceptionSet = TypeAnalysis.this.exceptionSetFactory.createExceptionSet();
                this.edgeExceptionMap.put(edge, edgeExceptionSet);
            }
            return edgeExceptionSet;
        }
    }
}

