/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumberDataflowFactory
extends AnalysisFactory<ValueNumberDataflow> {
    public ValueNumberDataflowFactory() {
        super("value number analysis", ValueNumberDataflow.class);
    }

    @Override
    public ValueNumberDataflow analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        MethodGen methodGen = this.getMethodGen(analysisCache, descriptor);
        if (methodGen == null) {
            throw new MethodUnprofitableException(descriptor);
        }
        DepthFirstSearch dfs = this.getDepthFirstSearch(analysisCache, descriptor);
        LoadedFieldSet loadedFieldSet = this.getLoadedFieldSet(analysisCache, descriptor);
        ValueNumberAnalysis analysis = new ValueNumberAnalysis(methodGen, dfs, loadedFieldSet, AnalysisContext.currentAnalysisContext().getLookupFailureCallback());
        analysis.setMergeTree(new MergeTree(analysis.getFactory()));
        CFG cfg = this.getCFG(analysisCache, descriptor);
        ValueNumberDataflow vnaDataflow = new ValueNumberDataflow(cfg, analysis);
        vnaDataflow.execute();
        if (ClassContext.DUMP_DATAFLOW_ANALYSIS) {
            TreeSet<Location> tree = new TreeSet<Location>();
            Iterator<Location> locs = cfg.locationIterator();
            while (locs.hasNext()) {
                Location loc = locs.next();
                tree.add(loc);
            }
            System.out.println("\n\nValue number analysis for " + descriptor.getName() + " {");
            for (Location loc : tree) {
                System.out.println("\nBefore: " + vnaDataflow.getFactAtLocation(loc));
                System.out.println("Location: " + loc);
                System.out.println("After: " + vnaDataflow.getFactAfterLocation(loc));
            }
            System.out.println("}\n");
        }
        return vnaDataflow;
    }
}

