/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud.db;

import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class IPAddressLookup {
    volatile String ipAddress = "unknown";
    CountDownLatch latch = new CountDownLatch(1);

    IPAddressLookup() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                BufferedReader in = null;
                try {
                    URL u = new URL("http://www.whatismyip.org/");
                    URLConnection c = u.openConnection();
                    in = new BufferedReader(new InputStreamReader(c.getInputStream()));
                    IPAddressLookup.this.ipAddress = in.readLine();
                    IPAddressLookup.this.latch.countDown();
                }
                catch (IOException iOException) {
                    IPAddressLookup.this.latch.countDown();
                    Util.closeSilently(in);
                    catch (Throwable throwable) {
                        IPAddressLookup.this.latch.countDown();
                        Util.closeSilently(in);
                        throw throwable;
                    }
                }
                Util.closeSilently(in);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public String get() {
        try {
            this.latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.ipAddress;
    }
}

