/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BadlyOverriddenAdapter
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private boolean isAdapter;
    private Map<String, String> methodMap;
    private Map<String, BugInstance> badOverrideMap;

    public BadlyOverriddenAdapter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.methodMap = new HashMap<String, String>();
        this.badOverrideMap = new HashMap<String, BugInstance>();
    }

    public void visit(JavaClass obj) {
        try {
            this.methodMap.clear();
            this.badOverrideMap.clear();
            JavaClass superClass = obj.getSuperClass();
            if (superClass == null) {
                return;
            }
            String packageName = superClass.getPackageName();
            String className = superClass.getClassName();
            boolean bl = this.isAdapter = className.endsWith("Adapter") && (packageName.equals("java.awt.event") || packageName.equals("javax.swing.event")) || className.equals("DefaultHandler") && packageName.equals("org.xml.sax.helpers");
            if (this.isAdapter) {
                Method[] methods;
                for (Method method1 : methods = superClass.getMethods()) {
                    this.methodMap.put(method1.getName(), method1.getSignature());
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public void visitAfter(JavaClass obj) {
        for (BugInstance bi : this.badOverrideMap.values()) {
            if (bi == null) continue;
            this.bugReporter.reportBug(bi);
        }
    }

    public void visit(Method obj) {
        if (this.isAdapter) {
            String methodName = obj.getName();
            String signature = this.methodMap.get(methodName);
            if (!methodName.equals("<init>") && signature != null) {
                if (!signature.equals(obj.getSignature())) {
                    if (!this.badOverrideMap.keySet().contains(methodName)) {
                        this.badOverrideMap.put(methodName, new BugInstance(this, "BOA_BADLY_OVERRIDDEN_ADAPTER", 2).addClassAndMethod(this).addSourceLine(this));
                    }
                } else {
                    this.badOverrideMap.put(methodName, null);
                }
            }
        }
    }
}

