/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class CheckImmutableAnnotation
extends PreorderVisitor
implements Detector {
    BugReporter bugReporter;

    public CheckImmutableAnnotation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitJavaClass(JavaClass obj) {
        JCIPAnnotationDatabase jcipAnotationDatabase = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase();
        if (jcipAnotationDatabase.hasClassAnnotation(obj.getClassName().replace('/', '.'), "Immutable")) {
            super.visitJavaClass(obj);
        }
    }

    public void visit(Field obj) {
        if (!obj.isFinal()) {
            this.bugReporter.reportBug(new BugInstance(this, "JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS", 2).addClass(this).addVisitedField(this));
        }
    }

    public void report() {
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept(this);
    }
}

