/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import java.util.BitSet;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;

public class MethodReturnValueStreamFactory
implements StreamFactory {
    private static final BitSet invokeOpcodeSet = new BitSet();
    private ObjectType baseClassType;
    private String methodName;
    private String methodSig;
    private boolean isUninteresting;
    private String bugType;

    public MethodReturnValueStreamFactory(String baseClass, String methodName, String methodSig) {
        this.baseClassType = ObjectTypeFactory.getInstance(baseClass);
        this.methodName = methodName;
        this.methodSig = methodSig;
        this.isUninteresting = true;
    }

    public MethodReturnValueStreamFactory(String baseClass, String methodName, String methodSig, String bugType) {
        this.baseClassType = ObjectTypeFactory.getInstance(baseClass);
        this.methodName = methodName;
        this.methodSig = methodSig;
        this.isUninteresting = false;
        this.bugType = bugType;
    }

    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        try {
            Instruction ins = location.getHandle().getInstruction();
            short opcode = ins.getOpcode();
            if (!invokeOpcodeSet.get(opcode)) {
                return null;
            }
            InvokeInstruction inv = (InvokeInstruction)ins;
            ReferenceType classType = inv.getReferenceType(cpg);
            if (!Hierarchy.isSubtype(classType, this.baseClassType)) {
                return null;
            }
            String methodName = inv.getMethodName(cpg);
            String methodSig = inv.getSignature(cpg);
            if (!this.methodName.equals(methodName) || !this.methodSig.equals(methodSig)) {
                return null;
            }
            String streamClass = type.getClassName();
            Stream result = new Stream(location, streamClass, streamClass).setIgnoreImplicitExceptions(true).setIsOpenOnCreation(true);
            if (!this.isUninteresting) {
                result.setInteresting(this.bugType);
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            lookupFailureCallback.reportMissingClass(e);
            return null;
        }
    }

    static {
        invokeOpcodeSet.set(185);
        invokeOpcodeSet.set(183);
        invokeOpcodeSet.set(184);
        invokeOpcodeSet.set(182);
    }
}

