/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MemberMatcher;
import edu.umd.cs.findbugs.filter.SignatureUtil;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class MethodMatcher
extends MemberMatcher
implements Matcher {
    public MethodMatcher(String name) {
        super(name);
    }

    public MethodMatcher(String name, String role) {
        super(name, null, role);
    }

    public MethodMatcher(String name, String params, String returns) {
        super(name, SignatureUtil.createMethodSignature(params, returns));
    }

    public MethodMatcher(String name, String params, String returns, String role) {
        super(name, SignatureUtil.createMethodSignature(params, returns), role);
    }

    public boolean match(BugInstance bugInstance) {
        MethodAnnotation methodAnnotation = null;
        if (this.role == null || this.role.equals("")) {
            methodAnnotation = bugInstance.getPrimaryMethod();
        } else {
            for (BugAnnotation bugAnnotation : bugInstance.getAnnotations()) {
                if (!(bugAnnotation instanceof MethodAnnotation) || !this.role.equals(bugAnnotation.getDescription())) continue;
                methodAnnotation = (MethodAnnotation)bugAnnotation;
                break;
            }
        }
        if (methodAnnotation == null) {
            return false;
        }
        if (!this.name.match(methodAnnotation.getMethodName())) {
            return false;
        }
        return this.signature == null || this.signature.equals(methodAnnotation.getMethodSignature());
    }

    public String toString() {
        return "Method(" + super.toString() + ")";
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("name", this.name.getSpec()).addOptionalAttribute("signature", this.signature).addOptionalAttribute("role", this.role);
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("Method", attributes);
    }
}

