/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.model;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovedClassMap
implements ClassNameRewriter {
    private static final boolean DEBUG = SystemProperties.getBoolean("movedClasses.debug");
    private BugCollection before;
    private BugCollection after;
    private Map<String, String> rewriteMap;

    public MovedClassMap(BugCollection before, BugCollection after) {
        this.before = before;
        this.after = after;
        this.rewriteMap = new HashMap<String, String>();
    }

    public MovedClassMap execute() {
        Set<String> beforeClasses = this.buildClassSet(this.before);
        Set<String> afterClasses = this.buildClassSet(this.after);
        HashSet<String> removedClasses = new HashSet<String>(beforeClasses);
        removedClasses.removeAll(afterClasses);
        HashSet<String> addedClasses = new HashSet<String>(afterClasses);
        addedClasses.removeAll(beforeClasses);
        Map<String, String> removedShortNameToFullNameMap = this.buildShortNameToFullNameMap(removedClasses);
        for (String fullAddedName : addedClasses) {
            String shortAddedName = this.getShortClassName(fullAddedName);
            String fullRemovedName = removedShortNameToFullNameMap.get(shortAddedName);
            if (fullRemovedName == null) continue;
            if (DEBUG) {
                System.err.println(fullAddedName + " --> " + fullRemovedName);
            }
            this.rewriteMap.put(fullAddedName, fullRemovedName);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.rewriteMap.isEmpty();
    }

    @Override
    public String rewriteClassName(String className) {
        String rewrittenClassName = this.rewriteMap.get(className);
        if (rewrittenClassName != null) {
            className = rewrittenClassName;
        }
        return className;
    }

    private Set<String> buildClassSet(BugCollection bugCollection) {
        HashSet<String> classSet = new HashSet<String>();
        for (BugInstance warning : bugCollection) {
            Iterator<BugAnnotation> j = warning.annotationIterator();
            while (j.hasNext()) {
                BugAnnotation annotation = j.next();
                if (!(annotation instanceof ClassAnnotation)) continue;
                classSet.add(((ClassAnnotation)annotation).getClassName());
            }
        }
        return classSet;
    }

    private Map<String, String> buildShortNameToFullNameMap(Set<String> classSet) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String className : classSet) {
            String shortClassName = this.getShortClassName(className);
            result.put(shortClassName, className);
        }
        return result;
    }

    private String getShortClassName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            className = className.substring(lastDot + 1);
        }
        return className.toLowerCase(Locale.US).replace('+', '$');
    }
}

