/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static Collection<Runnable> runAtShutdown;
    static final Pattern tag;

    public static int compare(int x, int y) {
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static int compare(long x, long y) {
        if (x > y) {
            return 1;
        }
        if (x < y) {
            return -1;
        }
        return 0;
    }

    public static Iterable<Integer> setBitIteratable(final BitSet b) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return Util.setBitIterator(b);
            }
        };
    }

    public static Iterator<Integer> setBitIterator(final BitSet b) {
        return new Iterator<Integer>(){
            int nextBit;
            {
                this.nextBit = b.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.nextBit >= 0;
            }

            @Override
            public Integer next() {
                int result = this.nextBit;
                this.nextBit = b.nextSetBit(this.nextBit + 1);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String repeat(String s, int number) {
        StringBuilder b = new StringBuilder(s.length() * number);
        for (int i = 0; i < number; ++i) {
            b.append(s);
        }
        return b.toString();
    }

    public static synchronized void runLogAtShutdown(Runnable r) {
        if (ShutdownLogging.LOGGING) {
            if (runAtShutdown == null) {
                runAtShutdown = new LinkedList<Runnable>();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        for (Runnable r : runAtShutdown) {
                            try {
                                r.run();
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            runAtShutdown.add(r);
        }
    }

    public static <T> Set<T> emptyOrNonnullSingleton(T t) {
        if (t == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(t);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public static int nullSafeHashcode(@CheckForNull Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static <T> boolean nullSafeEquals(@CheckForNull T o1, @CheckForNull T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <T extends Comparable<? super T>> int nullSafeCompareTo(@CheckForNull T o1, @CheckForNull T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static Reader getReader(@WillCloseWhenClosed InputStream in) throws UnsupportedEncodingException {
        return new InputStreamReader(in, "UTF-8");
    }

    public static Reader getFileReader(String filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Reader getFileReader(File filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getReader(new FileInputStream(filename));
    }

    public static Writer getWriter(@WillCloseWhenClosed OutputStream out) throws UnsupportedEncodingException, FileNotFoundException {
        return new OutputStreamWriter(out, "UTF-8");
    }

    public static Writer getFileWriter(String filename) throws UnsupportedEncodingException, FileNotFoundException {
        return Util.getWriter(new FileOutputStream(filename));
    }

    public static void closeSilently(@WillClose Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose Reader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(@WillClose OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getXMLType(@WillNotClose InputStream in) throws IOException {
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Input stream does not support mark");
        }
        in.mark(5000);
        BufferedReader r = null;
        try {
            String s;
            r = new BufferedReader(Util.getReader(in), 2000);
            int count = 0;
            while (count < 4 && (s = r.readLine()) != null) {
                Matcher m = tag.matcher(s);
                if (!m.find()) continue;
                String string = m.group(1);
                return string;
            }
            throw new IOException("Didn't find xml tag");
        }
        finally {
            in.reset();
        }
    }

    public static IOException makeIOException(String msg, Throwable cause) {
        IOException e = new IOException(msg);
        e.initCause(cause);
        return e;
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(lastDot + 1).toLowerCase();
    }

    public static void throwIOException(String msg, Throwable cause) throws IOException {
        IOException e = new IOException(msg);
        e.initCause(cause);
        throw e;
    }

    public static <E> E first(Iterable<E> i) {
        Iterator<E> iterator = i.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("iterator has no elements");
        }
        return iterator.next();
    }

    public static String commonPrefix(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < minLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return s1.substring(0, i);
        }
        if (s1.length() == minLength) {
            return s1;
        }
        assert (s2.length() == minLength);
        return s2;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> m) {
        return new SetFromMap<E>(m);
    }

    static {
        tag = Pattern.compile("^\\s*<(\\w+)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetFromMap<E>
    extends AbstractSet<E> {
        final Map<E, Boolean> m;
        final Set<E> s;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.s).equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }
    }

    static class ShutdownLogging {
        public static final boolean LOGGING = SystemProperties.getBoolean("findbugs.shutdownLogging");

        ShutdownLogging() {
        }
    }
}

