/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.analyzers.ArchiveScanner;
import org.jboss.tattletale.analyzers.DirectoryScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.BlackListedReport;
import org.jboss.tattletale.reporting.CDI10;
import org.jboss.tattletale.reporting.CircularDependencyReport;
import org.jboss.tattletale.reporting.ClassLocationReport;
import org.jboss.tattletale.reporting.DependantsReport;
import org.jboss.tattletale.reporting.DependsOnReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.EliminateJarsReport;
import org.jboss.tattletale.reporting.GraphvizReport;
import org.jboss.tattletale.reporting.InvalidVersionReport;
import org.jboss.tattletale.reporting.JarReport;
import org.jboss.tattletale.reporting.JavaEE5;
import org.jboss.tattletale.reporting.MultipleJarsReport;
import org.jboss.tattletale.reporting.MultipleLocationsReport;
import org.jboss.tattletale.reporting.NoVersionReport;
import org.jboss.tattletale.reporting.OSGiReport;
import org.jboss.tattletale.reporting.PackageMultipleJarsReport;
import org.jboss.tattletale.reporting.Report;
import org.jboss.tattletale.reporting.SealedReport;
import org.jboss.tattletale.reporting.Seam22;
import org.jboss.tattletale.reporting.SignReport;
import org.jboss.tattletale.reporting.Spring25;
import org.jboss.tattletale.reporting.SunJava5;
import org.jboss.tattletale.reporting.SunJava6;
import org.jboss.tattletale.reporting.TransitiveDependantsReport;
import org.jboss.tattletale.reporting.TransitiveDependsOnReport;
import org.jboss.tattletale.reporting.UnusedJarReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private String source = ".";
    private String destination = ".";
    private String configuration = null;
    private String filter = null;
    private String classloaderStructure = null;
    private String profiles = null;
    private String excludes = null;
    private String blacklisted = null;
    private boolean failOnInfo = false;
    private boolean failOnWarn = false;
    private boolean failOnError = false;
    private String reports = "*";

    public void setSource(String source) {
        this.source = source;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setClassLoaderStructure(String cls) {
        this.classloaderStructure = cls;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public void setBlacklisted(String blacklisted) {
        this.blacklisted = blacklisted;
    }

    public void setFailOnInfo(boolean b) {
        this.failOnInfo = b;
    }

    public void setFailOnWarn(boolean b) {
        this.failOnWarn = b;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setReports(String reports) {
        this.reports = reports;
    }

    public void execute() throws Exception {
        File f;
        String token;
        StringTokenizer st;
        Properties config = null;
        Properties filters = null;
        config = this.configuration != null ? this.loadConfiguration() : this.loadDefaultConfiguration();
        filters = this.filter != null ? this.loadFilters() : this.loadDefaultFilters();
        HashSet<String> profileSet = null;
        boolean allProfiles = false;
        HashSet<String> blacklistedSet = null;
        HashSet<String> excludeSet = null;
        boolean allReports = false;
        HashSet<String> reportSet = null;
        if (this.classloaderStructure == null) {
            this.classloaderStructure = config.getProperty("classloader");
        }
        if (this.profiles != null) {
            profileSet = new HashSet<String>();
            st = new StringTokenizer(this.profiles, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if ("*".equals(token)) {
                    allProfiles = true;
                    continue;
                }
                allProfiles = false;
                profileSet.add(token);
            }
        }
        if (profileSet == null && config.getProperty("profiles") != null) {
            profileSet = new HashSet();
            st = new StringTokenizer(config.getProperty("profiles"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if ("*".equals(token)) {
                    allProfiles = true;
                    continue;
                }
                allProfiles = false;
                profileSet.add(token);
            }
        }
        if (this.blacklisted != null) {
            blacklistedSet = new HashSet<String>();
            st = new StringTokenizer(this.blacklisted, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (token.endsWith(".*")) {
                    token.substring(0, token.indexOf(".*"));
                }
                if (token.endsWith(".class")) {
                    token.substring(0, token.indexOf(".class"));
                }
                blacklistedSet.add(token);
            }
        }
        if (blacklistedSet == null && config.getProperty("blacklisted") != null) {
            blacklistedSet = new HashSet();
            st = new StringTokenizer(config.getProperty("blacklisted"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                if (token.endsWith(".*")) {
                    token.substring(0, token.indexOf(".*"));
                }
                if (token.endsWith(".class")) {
                    token.substring(0, token.indexOf(".class"));
                }
                blacklistedSet.add(token);
            }
        }
        if (this.excludes != null) {
            excludeSet = new HashSet<String>();
            excludeSet.addAll(this.parseExcludes(this.excludes));
        }
        if (excludeSet == null && config.getProperty("excludes") != null) {
            excludeSet = new HashSet();
            excludeSet.addAll(this.parseExcludes(config.getProperty("excludes")));
        }
        if (this.reports != null && this.reports.trim().equals("*") || config.getProperty("reports") != null && config.getProperty("reports").equals("*")) {
            allReports = true;
        }
        if (!allReports && this.reports != null) {
            reportSet = new HashSet<String>();
            st = new StringTokenizer(this.reports, ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                reportSet.add(token);
            }
        }
        if (!allReports && reportSet == null && config.getProperty("reports") != null) {
            reportSet = new HashSet();
            st = new StringTokenizer(config.getProperty("reports"), ",");
            while (st.hasMoreTokens()) {
                token = st.nextToken().trim();
                reportSet.add(token);
            }
        }
        if (!allReports && reportSet == null) {
            allReports = true;
        }
        if (this.classloaderStructure == null || this.classloaderStructure.trim().equals("")) {
            this.classloaderStructure = "org.jboss.tattletale.reporting.classloader.NoopClassLoaderStructure";
        }
        HashMap<String, TreeSet<Location>> locationsMap = new HashMap<String, TreeSet<Location>>();
        TreeSet<Archive> archives = new TreeSet<Archive>();
        TreeMap<String, SortedSet<String>> gProvides = new TreeMap<String, SortedSet<String>>();
        ArrayList<Archive> known = new ArrayList<Archive>();
        if (profileSet == null || allProfiles || profileSet.size() == 0 || profileSet.contains("java5") || profileSet.contains("Sun Java 5")) {
            known.add(new SunJava5());
        }
        if (profileSet == null || allProfiles || profileSet.contains("java6") || profileSet.contains("Sun Java 6")) {
            known.add(new SunJava6());
        }
        if (allProfiles || profileSet != null && (profileSet.contains("ee5") || profileSet.contains("Java Enterprise 5"))) {
            known.add(new JavaEE5());
        }
        if (allProfiles || profileSet != null && (profileSet.contains("seam22") || profileSet.contains("Seam 2.2"))) {
            known.add(new Seam22());
        }
        if (allProfiles || profileSet != null && (profileSet.contains("cdi10") || profileSet.contains("CDI 1.0"))) {
            known.add(new CDI10());
        }
        if (allProfiles || profileSet != null && (profileSet.contains("spring25") || profileSet.contains("Spring 2.5"))) {
            known.add(new Spring25());
        }
        if ((f = new File(this.source)).isDirectory()) {
            List<File> fileList = DirectoryScanner.scan(f, excludeSet);
            for (File file : fileList) {
                Archive archive = ArchiveScanner.scan(file, gProvides, known, blacklistedSet);
                if (archive == null) continue;
                TreeSet<Location> locations = (TreeSet<Location>)locationsMap.get(archive.getName());
                if (locations == null) {
                    locations = new TreeSet<Location>();
                }
                locations.addAll(archive.getLocations());
                locationsMap.put(archive.getName(), locations);
                if (archives.contains(archive)) continue;
                archives.add(archive);
            }
            for (Archive a : archives) {
                SortedSet locations = (SortedSet)locationsMap.get(a.getName());
                for (Location l : locations) {
                    a.addLocation(l);
                }
            }
            String outputDir = this.setupOutputDir(this.destination);
            this.outputReport(outputDir, allReports, reportSet, this.classloaderStructure, filters, archives, gProvides, known);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadConfiguration() {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.configuration);
            properties.load(fis);
        }
        catch (IOException e) {
            System.err.println("Unable to open " + this.configuration);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultConfiguration() {
        FileInputStream fis;
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("jboss-tattletale.properties");
        boolean loaded = false;
        if (propertiesFile != null) {
            fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                loaded = true;
            }
            catch (IOException e) {
                System.err.println("Unable to open " + propertiesFile);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            fis = null;
            try {
                fis = new FileInputStream("jboss-tattletale.properties");
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ignore) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            InputStream is = null;
            try {
                ClassLoader cl = Main.class.getClassLoader();
                is = cl.getResourceAsStream("jboss-tattletale.properties");
                properties.load(is);
                loaded = true;
            }
            catch (Exception ie) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFilters() {
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.filter);
            properties.load(fis);
        }
        catch (IOException e) {
            System.err.println("Unable to open " + this.filter);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultFilters() {
        FileInputStream fis;
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("jboss-tattletale-filter.properties");
        boolean loaded = false;
        if (propertiesFile != null) {
            fis = null;
            try {
                fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                loaded = true;
            }
            catch (IOException e) {
                System.err.println("Unable to open " + propertiesFile);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!loaded) {
            fis = null;
            try {
                fis = new FileInputStream("jboss-tattletale-filter.properties");
                properties.load(fis);
                loaded = true;
            }
            catch (IOException ignore) {
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return properties;
    }

    private void outputReport(String outputDir, boolean allReports, Set<String> reportSet, String classloaderStructure, Properties filters, SortedSet<Archive> archives, SortedMap<String, SortedSet<String>> gProvides, List<Archive> known) throws Exception {
        TreeSet<Report> dependenciesReports = new TreeSet<Report>();
        TreeSet<Report> generalReports = new TreeSet<Report>();
        TreeSet<Report> archiveReports = new TreeSet<Report>();
        DependsOnReport dependsOn = new DependsOnReport(archives, known, classloaderStructure);
        if (allReports || reportSet.contains(dependsOn.getId())) {
            if (filters != null && filters.getProperty(dependsOn.getId()) != null) {
                dependsOn.setFilter(filters.getProperty(dependsOn.getId()));
            }
            dependsOn.generate(outputDir);
            dependenciesReports.add(dependsOn);
        }
        DependantsReport dependants = new DependantsReport(archives, classloaderStructure);
        if (allReports || reportSet.contains(dependants.getId())) {
            if (filters != null && filters.getProperty(dependants.getId()) != null) {
                dependants.setFilter(filters.getProperty(dependants.getId()));
            }
            dependants.generate(outputDir);
            dependenciesReports.add(dependants);
        }
        TransitiveDependsOnReport transitiveDependsOn = new TransitiveDependsOnReport(archives, known, classloaderStructure);
        if (allReports || reportSet.contains(transitiveDependsOn.getId())) {
            if (filters != null && filters.getProperty(transitiveDependsOn.getId()) != null) {
                transitiveDependsOn.setFilter(filters.getProperty(transitiveDependsOn.getId()));
            }
            transitiveDependsOn.generate(outputDir);
            dependenciesReports.add(transitiveDependsOn);
        }
        TransitiveDependantsReport transitiveDependants = new TransitiveDependantsReport(archives, classloaderStructure);
        if (allReports || reportSet.contains(transitiveDependants.getId())) {
            if (filters != null && filters.getProperty(transitiveDependants.getId()) != null) {
                transitiveDependants.setFilter(filters.getProperty(transitiveDependants.getId()));
            }
            transitiveDependants.generate(outputDir);
            dependenciesReports.add(transitiveDependants);
        }
        CircularDependencyReport circularDependency = new CircularDependencyReport(archives, classloaderStructure);
        if (allReports || reportSet.contains(circularDependency.getId())) {
            if (filters != null && filters.getProperty(circularDependency.getId()) != null) {
                circularDependency.setFilter(filters.getProperty(circularDependency.getId()));
            }
            circularDependency.generate(outputDir);
            dependenciesReports.add(circularDependency);
        }
        GraphvizReport graphviz = new GraphvizReport(archives, known, classloaderStructure);
        if (allReports || reportSet.contains(graphviz.getId())) {
            if (filters != null && filters.getProperty(graphviz.getId()) != null) {
                graphviz.setFilter(filters.getProperty(graphviz.getId()));
            }
            graphviz.generate(outputDir);
            dependenciesReports.add(graphviz);
        }
        for (Archive a : archives) {
            if (a.getType() != 0) continue;
            JarReport jar = new JarReport(a);
            if (!allReports && !reportSet.contains(jar.getId())) continue;
            if (filters != null && filters.getProperty(jar.getId()) != null) {
                jar.setFilter(filters.getProperty(jar.getId()));
            }
            jar.generate(outputDir);
            archiveReports.add(jar);
        }
        MultipleJarsReport multipleJars = new MultipleJarsReport(archives, gProvides);
        if (allReports || reportSet.contains(multipleJars.getId())) {
            if (filters != null && filters.getProperty(multipleJars.getId()) != null) {
                multipleJars.setFilter(filters.getProperty(multipleJars.getId()));
            }
            multipleJars.generate(outputDir);
            generalReports.add(multipleJars);
        }
        MultipleLocationsReport multipleLocations = new MultipleLocationsReport(archives);
        if (allReports || reportSet.contains(multipleLocations.getId())) {
            if (filters != null && filters.getProperty(multipleLocations.getId()) != null) {
                multipleLocations.setFilter(filters.getProperty(multipleLocations.getId()));
            }
            multipleLocations.generate(outputDir);
            generalReports.add(multipleLocations);
        }
        PackageMultipleJarsReport packageMultipleJars = new PackageMultipleJarsReport(archives, gProvides);
        if (allReports || reportSet.contains(packageMultipleJars.getId())) {
            if (filters != null && filters.getProperty(packageMultipleJars.getId()) != null) {
                packageMultipleJars.setFilter(filters.getProperty(packageMultipleJars.getId()));
            }
            packageMultipleJars.generate(outputDir);
            generalReports.add(packageMultipleJars);
        }
        EliminateJarsReport eliminateJars = new EliminateJarsReport(archives);
        if (allReports || reportSet.contains(eliminateJars.getId())) {
            if (filters != null && filters.getProperty(eliminateJars.getId()) != null) {
                eliminateJars.setFilter(filters.getProperty(eliminateJars.getId()));
            }
            eliminateJars.generate(outputDir);
            generalReports.add(eliminateJars);
        }
        NoVersionReport noVersion = new NoVersionReport(archives);
        if (allReports || reportSet.contains(noVersion.getId())) {
            if (filters != null && filters.getProperty(noVersion.getId()) != null) {
                noVersion.setFilter(filters.getProperty(noVersion.getId()));
            }
            noVersion.generate(outputDir);
            generalReports.add(noVersion);
        }
        ClassLocationReport classLocation = new ClassLocationReport(archives, gProvides);
        if (allReports || reportSet.contains(classLocation.getId())) {
            if (filters != null && filters.getProperty(classLocation.getId()) != null) {
                classLocation.setFilter(filters.getProperty(classLocation.getId()));
            }
            classLocation.generate(outputDir);
            generalReports.add(classLocation);
        }
        OSGiReport osgi = new OSGiReport(archives, known);
        if (allReports || reportSet.contains(osgi.getId())) {
            if (filters != null && filters.getProperty(osgi.getId()) != null) {
                osgi.setFilter(filters.getProperty(osgi.getId()));
            }
            ((Report)osgi).generate(outputDir);
            generalReports.add(osgi);
        }
        SignReport sign = new SignReport(archives);
        if (allReports || reportSet.contains(sign.getId())) {
            if (filters != null && filters.getProperty(sign.getId()) != null) {
                sign.setFilter(filters.getProperty(sign.getId()));
            }
            sign.generate(outputDir);
            generalReports.add(sign);
        }
        SealedReport sealed = new SealedReport(archives);
        if (allReports || reportSet.contains(sealed.getId())) {
            if (filters != null && filters.getProperty(sealed.getId()) != null) {
                sealed.setFilter(filters.getProperty(sealed.getId()));
            }
            sealed.generate(outputDir);
            generalReports.add(sealed);
        }
        InvalidVersionReport invalidversion = new InvalidVersionReport(archives);
        if (allReports || reportSet.contains(invalidversion.getId())) {
            if (filters != null && filters.getProperty(invalidversion.getId()) != null) {
                invalidversion.setFilter(filters.getProperty(invalidversion.getId()));
            }
            invalidversion.generate(outputDir);
            generalReports.add(invalidversion);
        }
        BlackListedReport blacklisted = new BlackListedReport(archives);
        if (allReports || reportSet.contains(blacklisted.getId())) {
            if (filters != null && filters.getProperty(blacklisted.getId()) != null) {
                blacklisted.setFilter(filters.getProperty(blacklisted.getId()));
            }
            blacklisted.generate(outputDir);
            generalReports.add(blacklisted);
        }
        UnusedJarReport unusedjar = new UnusedJarReport(archives);
        if (allReports || reportSet.contains(unusedjar.getId())) {
            if (filters != null && filters.getProperty(unusedjar.getId()) != null) {
                unusedjar.setFilter(filters.getProperty(unusedjar.getId()));
            }
            unusedjar.generate(outputDir);
            generalReports.add(unusedjar);
        }
        Dump.generateIndex(dependenciesReports, generalReports, archiveReports, outputDir);
        Dump.generateCSS(outputDir);
        if (this.failOnInfo || this.failOnWarn || this.failOnError) {
            boolean foundError = false;
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (Report report : dependenciesReports) {
                if (1 != report.getStatus() && 2 != report.getStatus()) continue;
                if (0 == report.getSeverity() && this.failOnInfo) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (1 == report.getSeverity() && this.failOnWarn) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (2 != report.getSeverity() || !this.failOnError) continue;
                if (!first) {
                    sb = sb.append(System.getProperty("line.separator"));
                }
                sb = sb.append(report.getId());
                sb = sb.append("=");
                if (1 == report.getStatus()) {
                    sb = sb.append("YELLOW");
                } else if (2 == report.getStatus()) {
                    sb = sb.append("RED");
                }
                foundError = true;
                first = false;
            }
            for (Report report : generalReports) {
                if (1 != report.getStatus() && 2 != report.getStatus()) continue;
                if (0 == report.getSeverity() && this.failOnInfo) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (1 == report.getSeverity() && this.failOnWarn) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (2 != report.getSeverity() || !this.failOnError) continue;
                if (!first) {
                    sb = sb.append(System.getProperty("line.separator"));
                }
                sb = sb.append(report.getId());
                sb = sb.append("=");
                if (1 == report.getStatus()) {
                    sb = sb.append("YELLOW");
                } else if (2 == report.getStatus()) {
                    sb = sb.append("RED");
                }
                foundError = true;
                first = false;
            }
            for (Report report : archiveReports) {
                if (1 != report.getStatus() && 2 != report.getStatus()) continue;
                if (0 == report.getSeverity() && this.failOnInfo) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (1 == report.getSeverity() && this.failOnWarn) {
                    if (!first) {
                        sb = sb.append(System.getProperty("line.separator"));
                    }
                    sb = sb.append(report.getId());
                    sb = sb.append("=");
                    if (1 == report.getStatus()) {
                        sb = sb.append("YELLOW");
                    } else if (2 == report.getStatus()) {
                        sb = sb.append("RED");
                    }
                    foundError = true;
                    first = false;
                    continue;
                }
                if (2 != report.getSeverity() || !this.failOnError) continue;
                if (!first) {
                    sb = sb.append(System.getProperty("line.separator"));
                }
                sb = sb.append(report.getId());
                sb = sb.append("=");
                if (1 == report.getStatus()) {
                    sb = sb.append("YELLOW");
                } else if (2 == report.getStatus()) {
                    sb = sb.append("RED");
                }
                foundError = true;
                first = false;
            }
            if (foundError) {
                throw new Exception(sb.toString());
            }
        }
    }

    private String setupOutputDir(String outputDir) throws IOException {
        File outputDirFile = new File(outputDir = !outputDir.substring(outputDir.length() - 1).equals(File.separator) ? outputDir + File.separator : outputDir);
        if (outputDirFile.exists()) {
            this.recursiveDelete(outputDirFile);
        }
        if (!outputDirFile.mkdirs()) {
            throw new IOException("Cannot create directory: " + outputDir);
        }
        return outputDir;
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private Set<String> parseExcludes(String s) {
        HashSet<String> result = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.startsWith("**")) {
                token = token.substring(2);
            }
            if (token.endsWith("**")) {
                token = token.substring(0, token.indexOf("**"));
            }
            result.add(token);
        }
        return result;
    }

    private static void usage() {
        System.out.println("Usage: Tattletale [-exclude=<excludes>] <scan-directory> [output-directory]");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                int arg = 0;
                Main main = new Main();
                if (args[arg].startsWith("-exclude=")) {
                    main.setExcludes(args[arg].substring(args[arg].indexOf("=") + 1));
                    ++arg;
                }
                main.setSource(args[arg]);
                main.setDestination(args.length > arg + 1 ? args[arg + 1] : ".");
                main.setFailOnInfo(false);
                main.setFailOnWarn(false);
                main.setFailOnError(false);
                main.execute();
            }
            catch (Exception e) {
                System.err.println("Exception: " + e.getMessage());
                e.printStackTrace(System.err);
            }
        } else {
            Main.usage();
        }
    }
}

