/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner {
    public static List<File> scan(File file) {
        return DirectoryScanner.scan(file, null);
    }

    public static List<File> scan(File file, Set<String> excludes) {
        try {
            return DirectoryScanner.getFileListing(file, excludes);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static List<File> getFileListing(File aStartingDir, Set<String> excludes) throws Exception {
        List<File> result = DirectoryScanner.getFileListingNoSort(aStartingDir, excludes);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir, Set<String> excludes) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".jar")) continue;
                boolean include = true;
                if (excludes != null) {
                    Iterator<String> it = excludes.iterator();
                    while (include && it.hasNext()) {
                        String exclude = it.next();
                        if (!file.getName().equals(exclude) && file.getAbsolutePath().indexOf(exclude) == -1) continue;
                        include = false;
                    }
                }
                if (!include) continue;
                result.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            List<File> deeperList = DirectoryScanner.getFileListingNoSort(file, excludes);
            result.addAll(deeperList);
        }
        return result;
    }
}

