/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackListedReport
extends Report {
    private static final String NAME = "Black listed";
    private static final String DIRECTORY = "blacklisted";

    public BlackListedReport(SortedSet<Archive> archives) {
        super(DIRECTORY, 2, archives, NAME, DIRECTORY);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Usage</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            boolean include = false;
            if (archive.getBlackListedDependencies() != null && archive.getBlackListedDependencies().size() > 0) {
                include = true;
                this.status = 2;
            }
            if (!include) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            bw.write("       <table>" + Dump.NEW_LINE);
            for (Map.Entry<String, SortedSet<String>> stringSortedSetEntry : archive.getBlackListedDependencies().entrySet()) {
                String pkg = stringSortedSetEntry.getKey();
                SortedSet<String> blpkgs = stringSortedSetEntry.getValue();
                bw.write("      <tr>" + Dump.NEW_LINE);
                bw.write("        <td>" + pkg + "</td>" + Dump.NEW_LINE);
                bw.write("        <td>");
                for (String blp : blpkgs) {
                    bw.write(blp + "<br>");
                }
                bw.write("</td>" + Dump.NEW_LINE);
                bw.write("      </tr>" + Dump.NEW_LINE);
            }
            bw.write("       </table>" + Dump.NEW_LINE);
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Black listed</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

