/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.util.List;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Report;
import org.jboss.tattletale.reporting.classloader.ClassLoaderStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLSReport
extends Report {
    private List<Archive> known;
    private ClassLoaderStructure cls = null;

    public CLSReport(String id, int severity, SortedSet<Archive> archives, String name, String directory, String classloaderStructure) {
        super(id, severity, archives, name, directory);
        this.setCLS(classloaderStructure);
    }

    public CLSReport(String id, int severity, SortedSet<Archive> archives, String name, String directory, String classloaderStructure, List<Archive> known) {
        this(id, severity, archives, name, directory, classloaderStructure);
        this.setKnown(known);
    }

    ClassLoaderStructure getCLS() {
        return this.cls;
    }

    private void setCLS(String classloaderStructure) {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(classloaderStructure);
            this.cls = (ClassLoaderStructure)c.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> c = CLSReport.class.getClassLoader().loadClass(classloaderStructure);
                this.cls = (ClassLoaderStructure)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setKnown(List<Archive> known) {
        this.known = known;
    }

    public List<Archive> getKnown() {
        return this.known;
    }
}

