/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularDependencyReport
extends CLSReport {
    private static final String NAME = "Circular Dependency";
    private static final String DIRECTORY = "circulardependency";

    public CircularDependencyReport(SortedSet<Archive> archives, String classloaderStructure) {
        super(DIRECTORY, 2, archives, NAME, DIRECTORY, classloaderStructure, null);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Circular Dependencies</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        TreeMap<String, SortedSet<String>> dependsOnMap = new TreeMap<String, SortedSet<String>>();
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            TreeSet<String> result = (TreeSet<String>)dependsOnMap.get(archive.getName());
            if (result == null) {
                result = new TreeSet<String>();
            }
            for (String require : archive.getRequires()) {
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (a.getType() != 0 || !a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
            }
            dependsOnMap.put(archive.getName(), result);
        }
        TreeMap<String, TreeSet<String>> transitiveDependsOnMap = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry entry : dependsOnMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            TreeSet<String> result = new TreeSet<String>();
            if (value != null && value.size() > 0) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, archive, dependsOnMap, result);
                }
            }
            transitiveDependsOnMap.put(archive, result);
        }
        boolean odd = true;
        for (Map.Entry entry : transitiveDependsOnMap.entrySet()) {
            String archive = (String)entry.getKey();
            SortedSet value = (SortedSet)entry.getValue();
            if (value.size() == 0) continue;
            TreeSet<String> circular = new TreeSet<String>();
            for (String r : value) {
                SortedSet td = (SortedSet)transitiveDependsOnMap.get(r);
                if (td == null || !td.contains(archive)) continue;
                circular.add(r);
            }
            if (circular.size() <= 0) continue;
            this.status = 2;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive + ".html\">" + archive + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            Iterator valueIt = value.iterator();
            while (valueIt.hasNext()) {
                String r;
                r = (String)valueIt.next();
                if (circular.contains(r)) {
                    bw.write("<a href=\"../jar/" + r + ".html\">" + r + " (*)</a>");
                } else {
                    bw.write("<a href=\"../jar/" + r + ".html\">" + r + "</a>");
                }
                if (!valueIt.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Circular Dependency</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }

    private void resolveDependsOn(String scanArchive, String archive, SortedMap<String, SortedSet<String>> map, SortedSet<String> result) {
        if (!archive.equals(scanArchive) && !result.contains(scanArchive)) {
            result.add(scanArchive);
            SortedSet value = (SortedSet)map.get(scanArchive);
            if (value != null) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, archive, map, result);
                }
            }
        }
    }
}

