/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependsOnReport
extends CLSReport {
    private static final String NAME = "Depends On";
    private static final String DIRECTORY = "dependson";

    public DependsOnReport(SortedSet<Archive> archives, List<Archive> known, String classloaderStructure) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY, classloaderStructure, known);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Depends On</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        for (Archive archive : this.archives) {
            if (archive.getType() != 0) continue;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            TreeSet<String> result = new TreeSet<String>();
            for (String require : archive.getRequires()) {
                boolean found = false;
                Iterator ait = this.archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = (Archive)ait.next();
                    if (!a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
                if (!found) {
                    Iterator<Archive> kit = this.getKnown().iterator();
                    while (!found && kit.hasNext()) {
                        Archive a = kit.next();
                        if (!a.doesProvide(require)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                result.add(require);
            }
            if (result.size() == 0) {
                bw.write("&nbsp;");
            } else {
                Iterator resultIt = result.iterator();
                while (resultIt.hasNext()) {
                    String r = (String)resultIt.next();
                    if (r.endsWith(".jar")) {
                        bw.write("<a href=\"../jar/" + r + ".html\">" + r + "</a>");
                    } else {
                        bw.write("<i>" + r + "</i>");
                        this.status = 1;
                    }
                    if (!resultIt.hasNext()) continue;
                    bw.write(", ");
                }
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Depends On</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

