/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleLocationsReport
extends Report {
    private static final String NAME = "Multiple Locations";
    private static final String DIRECTORY = "multiplelocations";

    public MultipleLocationsReport(SortedSet<Archive> archives) {
        super(DIRECTORY, 1, archives, NAME, DIRECTORY);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Name</th>" + Dump.NEW_LINE);
        bw.write("     <th>Location</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        for (Archive a : this.archives) {
            if (a.getType() != 0 || a.getLocations().size() <= 1) continue;
            this.status = 1;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + a.getName() + ".html\">" + a.getName() + "</a></td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            Iterator lit = a.getLocations().iterator();
            while (lit.hasNext()) {
                Location location = (Location)lit.next();
                bw.write(location.getFilename());
                if (!lit.hasNext()) continue;
                bw.write("<br>");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Multiple Locations</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

