/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageMultipleJarsReport
extends Report {
    private static final String NAME = "Multiple Jar files (Packages)";
    private static final String DIRECTORY = "multiplejarspackage";
    private SortedMap<String, SortedSet<String>> gProvides;

    public PackageMultipleJarsReport(SortedSet<Archive> archives, SortedMap<String, SortedSet<String>> gProvides) {
        super(DIRECTORY, 1, archives, NAME, DIRECTORY);
        this.gProvides = gProvides;
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Package</th>" + Dump.NEW_LINE);
        bw.write("     <th>Jar files</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        TreeMap<String, TreeSet<String>> packageProvides = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry<String, SortedSet<String>> entry : this.gProvides.entrySet()) {
            String clz = entry.getKey();
            SortedSet<String> archives = entry.getValue();
            String packageName = null;
            packageName = clz.indexOf(46) == -1 ? "" : clz.substring(0, clz.lastIndexOf(46));
            TreeSet<String> packageJars = (TreeSet<String>)packageProvides.get(packageName);
            if (packageJars == null) {
                packageJars = new TreeSet<String>();
            }
            packageJars.addAll(archives);
            packageProvides.put(packageName, packageJars);
        }
        boolean odd = true;
        for (Map.Entry entry : packageProvides.entrySet()) {
            String pkg = (String)entry.getKey();
            SortedSet archives = (SortedSet)entry.getValue();
            if (archives.size() <= 1) continue;
            this.status = 1;
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td>" + pkg + "</td>" + Dump.NEW_LINE);
            bw.write("     <td>");
            Iterator sit = archives.iterator();
            while (sit.hasNext()) {
                String archive = (String)sit.next();
                bw.write("<a href=\"../jar/" + archive + ".html\">" + archive + "</a>" + Dump.NEW_LINE);
                if (!sit.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.NEW_LINE);
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Multiple Jar files (Packages)</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

