/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignReport
extends Report {
    private static final String NAME = "Signing information";
    private static final String DIRECTORY = "sign";

    public SignReport(SortedSet<Archive> archives) {
        super(DIRECTORY, 0, archives, NAME, DIRECTORY);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Status</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        int signed = 0;
        int unsigned = 0;
        for (Archive archive : this.archives) {
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            if (archive.getSign() != null) {
                bw.write("     <td style=\"color: red;\">Signed</td>" + Dump.NEW_LINE);
                ++signed;
            } else {
                bw.write("     <td style=\"color: green;\">Unsigned</td>" + Dump.NEW_LINE);
                ++unsigned;
            }
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
        if (signed > 0 && unsigned > 0) {
            this.status = 1;
        }
        bw.write(Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Status</th>" + Dump.NEW_LINE);
        bw.write("     <th>Archives</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Signed</td>" + Dump.NEW_LINE);
        bw.write("     <td style=\"color: red;\">" + signed + "</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Unsigned</td>" + Dump.NEW_LINE);
        bw.write("     <td style=\"color: green;\">" + unsigned + "</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Signing information</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

