/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.SunJava5JCE;
import org.jboss.tattletale.reporting.SunJava5JSSE;

public class SunJava5
extends NestableArchive {
    private static SortedSet<String> classSet = new TreeSet<String>();

    public SunJava5() {
        super(0, "Sun Java 5", 49, null, null, null, null, null, null, null, null);
        Location l = new Location("rt.jar", "Sun JDK5");
        this.addLocation(l);
        this.addSubArchive(new SunJava5JCE());
        this.addSubArchive(new SunJava5JSSE());
    }

    public boolean doesProvide(String clz) {
        if (classSet.contains(clz)) {
            return true;
        }
        if (this.getSubArchives() != null) {
            for (Archive a : this.getSubArchives()) {
                if (!a.doesProvide(clz)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = SunJava5.class.getClassLoader().getResourceAsStream("sunjdk5.clz.gz");
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            while (s != null) {
                classSet.add(s);
                s = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

