/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.Location;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.SunJava6JCE;
import org.jboss.tattletale.reporting.SunJava6JSSE;

public class SunJava6
extends NestableArchive {
    private static SortedSet<String> classSet = new TreeSet<String>();

    public SunJava6() {
        super(0, "Sun Java 6", 50, null, null, null, null, null, null, null, null);
        Location l = new Location("rt.jar", "Sun JDK6");
        this.addLocation(l);
        this.addSubArchive(new SunJava6JCE());
        this.addSubArchive(new SunJava6JSSE());
    }

    public boolean doesProvide(String clz) {
        if (classSet.contains(clz)) {
            return true;
        }
        if (this.getSubArchives() != null) {
            for (Archive a : this.getSubArchives()) {
                if (!a.doesProvide(clz)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = SunJava6.class.getClassLoader().getResourceAsStream("sunjdk6.clz.gz");
            GZIPInputStream gis = new GZIPInputStream(is);
            InputStreamReader isr = new InputStreamReader(gis);
            BufferedReader br = new BufferedReader(isr);
            String s = br.readLine();
            while (s != null) {
                classSet.add(s);
                s = br.readLine();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

