/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Report;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedJarReport
extends Report {
    private static final String NAME = "Unused Jar";
    private static final String DIRECTORY = "unusedjar";

    public UnusedJarReport(SortedSet<Archive> archives) {
        super(DIRECTORY, 1, archives, NAME, DIRECTORY);
    }

    @Override
    void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Archive</th>" + Dump.NEW_LINE);
        bw.write("     <th>Used</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        boolean odd = true;
        int used = 0;
        int unused = 0;
        for (Archive archive : this.archives) {
            boolean archiveStatus = false;
            Iterator it = this.archives.iterator();
            while (!archiveStatus && it.hasNext()) {
                Archive a = (Archive)it.next();
                if (archive.getName().equals(a.getName())) continue;
                Iterator sit = a.getRequires().iterator();
                while (!archiveStatus && sit.hasNext()) {
                    String require = (String)sit.next();
                    if (!archive.getProvides().keySet().contains(require)) continue;
                    archiveStatus = true;
                }
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
            }
            bw.write("     <td><a href=\"../jar/" + archive.getName() + ".html\">" + archive.getName() + "</a></td>" + Dump.NEW_LINE);
            if (archiveStatus) {
                bw.write("     <td style=\"color: green;\">Yes</td>" + Dump.NEW_LINE);
                ++used;
            } else {
                bw.write("     <td style=\"color: red;\">No</td>" + Dump.NEW_LINE);
                ++unused;
                this.status = 1;
            }
            bw.write("  </tr>" + Dump.NEW_LINE);
            odd = !odd;
        }
        bw.write("</table>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
        bw.write("<table>" + Dump.NEW_LINE);
        bw.write("  <tr>" + Dump.NEW_LINE);
        bw.write("     <th>Status</th>" + Dump.NEW_LINE);
        bw.write("     <th>Archives</th>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"rowodd\">" + Dump.NEW_LINE);
        bw.write("     <td>Used</td>" + Dump.NEW_LINE);
        bw.write("     <td style=\"color: green;\">" + used + "</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("  <tr class=\"roweven\">" + Dump.NEW_LINE);
        bw.write("     <td>Unused</td>" + Dump.NEW_LINE);
        bw.write("     <td style=\"color: red;\">" + unused + "</td>" + Dump.NEW_LINE);
        bw.write("  </tr>" + Dump.NEW_LINE);
        bw.write("</table>" + Dump.NEW_LINE);
    }

    @Override
    void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.NEW_LINE);
        bw.write(Dump.NEW_LINE);
        bw.write("<h1>Unused Jar</h1>" + Dump.NEW_LINE);
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.NEW_LINE);
        bw.write("<p>" + Dump.NEW_LINE);
    }
}

