/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api;

import com.github.fungal.api.Kernel;
import com.github.fungal.api.SecurityActions;
import com.github.fungal.api.configuration.KernelConfiguration;
import java.lang.reflect.Constructor;

public final class KernelFactory {
    private static final String KERNEL_IMPL = "com.github.fungal.impl.KernelImpl";

    private KernelFactory() {
    }

    public static synchronized Kernel create(KernelConfiguration kc) throws Exception {
        if (kc == null) {
            throw new IllegalArgumentException("KernelConfiguration is null");
        }
        Class<?> clz = Class.forName(KERNEL_IMPL);
        Constructor<?> c = SecurityActions.getConstructor(clz, KernelConfiguration.class);
        SecurityActions.setAccessible(c);
        return (Kernel)c.newInstance(kc);
    }
}

