/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.classloading;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class KernelClassLoader
extends URLClassLoader
implements Closeable {
    private static ConcurrentMap<String, Class<?>> simpleTypes = new ConcurrentHashMap(9);

    protected KernelClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return (Class)simpleTypes.get(name);
    }

    @Override
    public void close() throws IOException {
    }

    public void shutdown() throws IOException {
        super.close();
    }

    static {
        simpleTypes.put(Void.TYPE.getName(), Void.TYPE);
        simpleTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        simpleTypes.put(Short.TYPE.getName(), Short.TYPE);
        simpleTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        simpleTypes.put(Long.TYPE.getName(), Long.TYPE);
        simpleTypes.put(Character.TYPE.getName(), Character.TYPE);
        simpleTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        simpleTypes.put(Float.TYPE.getName(), Float.TYPE);
        simpleTypes.put(Double.TYPE.getName(), Double.TYPE);
    }
}

