/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.classloading;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static void setAccessible(final AccessibleObject ao) {
        if (System.getSecurityManager() == null) {
            ao.setAccessible(true);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }

    static Constructor<?> getDeclaredConstructor(final Class<?> c, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredConstructor(params);
        }
        Constructor result = (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<?>>(){

            @Override
            public Constructor<?> run() {
                try {
                    return c.getDeclaredConstructor(params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

