/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.configuration;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeploymentOrder
implements Comparator<URL>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> order;

    public DeploymentOrder() {
        this.order = new ArrayList<String>(1);
        this.order.add(".xml");
    }

    public DeploymentOrder(List<String> extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("Extensions is null");
        }
        if (extensions.size() == 0) {
            throw new IllegalArgumentException("Extensions is empty");
        }
        this.order = new ArrayList<String>(extensions);
    }

    public List<String> getOrder() {
        return Collections.unmodifiableList(this.order);
    }

    public int getOrderIndex(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        String file = url.getFile();
        int index = Integer.MAX_VALUE;
        for (int i = 0; i < this.order.size(); ++i) {
            String extension = this.order.get(i);
            if (!file.endsWith(extension)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public int compare(URL o1, URL o2) {
        String f1 = o1.getFile();
        String f2 = o2.getFile();
        int v1 = Integer.MAX_VALUE;
        int v2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.order.size(); ++i) {
            String extension = this.order.get(i);
            if (f1.endsWith(extension)) {
                v1 = i;
            }
            if (!f2.endsWith(extension)) continue;
            v2 = i;
        }
        if (v1 < v2) {
            return -1;
        }
        if (v1 > v2) {
            return 1;
        }
        return f1.compareTo(f2);
    }

    public int hashCode() {
        return this.order.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof DeploymentOrder)) {
            return false;
        }
        DeploymentOrder other = (DeploymentOrder)o;
        return this.order.equals(other.order);
    }
}

