/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.api.configuration;

import com.github.fungal.api.configuration.DeploymentOrder;
import com.github.fungal.api.events.EventListener;
import com.github.fungal.api.remote.Command;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KernelConfiguration {
    private String name = "fungal";
    private URL home = null;
    private int classLoader = 0;
    private String library = "lib";
    private String configuration = "config";
    private String system = "system";
    private String deploy = "deploy";
    private String repository = "repository";
    private boolean parallelDeploy = true;
    private String bindAddress = null;
    private ThreadGroup threadGroup = null;
    private boolean remoteAccess = true;
    private int remotePort = 1202;
    private boolean hotDeployment = true;
    private int hotDeploymentInterval = 5;
    private List<EventListener> eventListeners = null;
    private List<Command> commands = null;
    private DeploymentOrder deploymentOrder = null;
    private boolean management = true;
    private boolean usePlatformMBeanServer = false;
    private boolean remoteJmxAccess = false;
    private boolean beanManagement = false;
    private int rmiRegistryPort = 1203;
    private int rmiServerPort = 1204;

    public KernelConfiguration name(String n) {
        this.name = n;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KernelConfiguration home(URL h) {
        this.home = h;
        return this;
    }

    public URL getHome() {
        return this.home;
    }

    public KernelConfiguration classLoader(int type) {
        this.classLoader = type;
        return this;
    }

    public int getClassLoader() {
        return this.classLoader;
    }

    public KernelConfiguration library(String value) {
        this.library = value;
        return this;
    }

    public String getLibrary() {
        return this.library;
    }

    public KernelConfiguration configuration(String value) {
        this.configuration = value;
        return this;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public KernelConfiguration system(String value) {
        this.system = value;
        return this;
    }

    public String getSystem() {
        return this.system;
    }

    public KernelConfiguration deploy(String value) {
        this.deploy = value;
        return this;
    }

    public String getDeploy() {
        return this.deploy;
    }

    public KernelConfiguration repository(String value) {
        this.repository = value;
        return this;
    }

    public String getRepository() {
        return this.repository;
    }

    public KernelConfiguration parallelDeploy(boolean value) {
        this.parallelDeploy = value;
        return this;
    }

    public boolean isParallelDeploy() {
        return this.parallelDeploy;
    }

    public KernelConfiguration bindAddress(String ba) {
        this.bindAddress = ba;
        return this;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public KernelConfiguration threadGroup(ThreadGroup tg) {
        this.threadGroup = tg;
        return this;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public KernelConfiguration remoteAccess(boolean v) {
        this.remoteAccess = v;
        return this;
    }

    public boolean isRemoteAccess() {
        return this.remoteAccess;
    }

    public KernelConfiguration remotePort(int v) {
        this.remotePort = v;
        return this;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public KernelConfiguration hotDeployment(boolean v) {
        this.hotDeployment = v;
        return this;
    }

    public boolean isHotDeployment() {
        return this.hotDeployment;
    }

    public KernelConfiguration hotDeploymentInterval(int v) {
        this.hotDeploymentInterval = v;
        return this;
    }

    public int getHotDeploymentInterval() {
        return this.hotDeploymentInterval;
    }

    public KernelConfiguration eventListener(EventListener el) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<EventListener>(1);
        }
        this.eventListeners.add(el);
        return this;
    }

    public List<EventListener> getEventListeners() {
        if (this.eventListeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.eventListeners);
    }

    public KernelConfiguration command(Command c) {
        if (this.commands == null) {
            this.commands = new ArrayList<Command>(1);
        }
        this.commands.add(c);
        return this;
    }

    public List<Command> getCommands() {
        if (this.commands == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.commands);
    }

    public KernelConfiguration deploymentOrder(DeploymentOrder d) {
        this.deploymentOrder = d;
        return this;
    }

    public DeploymentOrder getDeploymentOrder() {
        if (this.deploymentOrder == null) {
            return new DeploymentOrder();
        }
        return this.deploymentOrder;
    }

    public KernelConfiguration management(boolean v) {
        this.management = v;
        return this;
    }

    public boolean isManagement() {
        return this.management;
    }

    public KernelConfiguration usePlatformMBeanServer(boolean v) {
        this.usePlatformMBeanServer = v;
        return this;
    }

    public boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public KernelConfiguration remoteJmxAccess(boolean v) {
        this.remoteJmxAccess = v;
        return this;
    }

    public boolean isRemoteJmxAccess() {
        return this.remoteJmxAccess;
    }

    public KernelConfiguration beanManagement(boolean v) {
        this.beanManagement = v;
        return this;
    }

    public boolean isBeanManagement() {
        return this.beanManagement;
    }

    public KernelConfiguration rmiRegistryPort(int port) {
        this.rmiRegistryPort = port;
        return this;
    }

    public int getRmiRegistryPort() {
        return this.rmiRegistryPort;
    }

    public KernelConfiguration rmiServerPort(int port) {
        this.rmiServerPort = port;
        return this;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }
}

