/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.cli;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;

public class CLI {
    private CLI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            CLI.usage();
        } else {
            Socket socket = null;
            try {
                String host = null;
                int port = 1202;
                int counter = 0;
                String command = "";
                if ("-h".equals(args[counter])) {
                    host = args[++counter];
                    ++counter;
                }
                if ("-p".equals(args[counter])) {
                    port = Integer.valueOf(args[++counter]);
                    ++counter;
                }
                command = args[counter];
                ++counter;
                if (host == null) {
                    host = "localhost";
                }
                socket = new Socket(host, port);
                ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
                oos.writeUTF("getcommand");
                oos.writeInt(1);
                oos.writeObject(command);
                oos.flush();
                ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
                Serializable result = (Serializable)ois.readObject();
                if (result == null || result instanceof Class[]) {
                    Class[] parameterTypes = (Class[])result;
                    Serializable[] arguments = null;
                    if (parameterTypes != null) {
                        arguments = new Serializable[parameterTypes.length];
                        for (int i = 0; i < parameterTypes.length; ++i) {
                            arguments[i] = CLI.getValue(parameterTypes[i], args[counter]);
                            ++counter;
                        }
                    }
                    CLI.executeCommand(host, port, command, arguments);
                } else {
                    System.err.println(result);
                }
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException host) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(String host, int port, String command, Serializable[] arguments) throws Throwable {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeUTF(command);
            if (arguments != null) {
                oos.writeInt(arguments.length);
                for (Serializable argument : arguments) {
                    oos.writeObject(argument);
                }
            } else {
                oos.writeInt(0);
            }
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            Serializable result = (Serializable)ois.readObject();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    System.out.println(result);
                } else {
                    System.out.println(Arrays.toString((Object[])result));
                }
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static Serializable getValue(Class<?> type, String value) {
        if (value == null) {
            return null;
        }
        if (String.class.equals(type)) {
            return value;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.valueOf(value);
        }
        if (Boolean.class.equals(type)) {
            return Boolean.valueOf(value);
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.valueOf(value);
        }
        if (Byte.class.equals(type)) {
            return Byte.valueOf(value);
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf(Character.valueOf(value.charAt(0)).charValue());
        }
        if (Character.class.equals(type)) {
            return Character.valueOf(value.charAt(0));
        }
        if (Double.TYPE.equals(type)) {
            return Double.valueOf(value);
        }
        if (Double.class.equals(type)) {
            return Double.valueOf(value);
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(Float.valueOf(value).floatValue());
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(value);
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.valueOf(value);
        }
        if (Integer.class.equals(type)) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(type)) {
            return Long.valueOf(value);
        }
        if (Long.class.equals(type)) {
            return Long.valueOf(value);
        }
        if (Short.TYPE.equals(type)) {
            return Short.valueOf(value);
        }
        if (Short.class.equals(type)) {
            return Short.valueOf(value);
        }
        if (URL.class.equals(type)) {
            try {
                URL url = null;
                url = !value.startsWith("file:") && !value.startsWith("http:") ? new File(value).toURI().toURL() : new URL(value);
                return url;
            }
            catch (Throwable t) {
                System.err.println(t);
                return null;
            }
        }
        System.err.println("Unknown type: " + type.getName() + " Value: " + value);
        return null;
    }

    private static void usage() {
        System.out.println("Usage: CLI <common> <command>");
        System.out.println(" Common:");
        System.out.println(" -------");
        System.out.println(" -h <host> (default: localhost)");
        System.out.println(" -p <port> (default: 1202)");
        System.out.println("");
        System.out.println(" Commands:");
        System.out.println(" ---------");
        System.out.println(" For a list of commands use \"help\"");
    }
}

