/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.api.deployment.BeanDeployment;
import com.github.fungal.impl.KernelImpl;
import com.github.fungal.impl.SecurityActions;
import com.github.fungal.impl.ServiceLifecycle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeploymentImpl
implements BeanDeployment {
    private URL deployment;
    private List<String> beans;
    private Map<String, List<Method>> uninstall;
    private Map<String, String> stops;
    private Map<String, String> destroys;
    private Set<String> ignoreStops;
    private Set<String> ignoreDestroys;
    private KernelImpl kernel;

    public BeanDeploymentImpl(URL deployment, List<String> beans, Map<String, List<Method>> uninstall, Map<String, String> stops, Map<String, String> destroys, Set<String> ignoreStops, Set<String> ignoreDestroys, KernelImpl kernel) {
        if (beans == null) {
            throw new IllegalArgumentException("Beans is null");
        }
        if (uninstall == null) {
            throw new IllegalArgumentException("Uninstall is null");
        }
        if (kernel == null) {
            throw new IllegalArgumentException("Kernel is null");
        }
        this.deployment = deployment;
        this.beans = beans;
        this.uninstall = uninstall;
        this.stops = stops;
        this.destroys = destroys;
        this.ignoreStops = ignoreStops;
        this.ignoreDestroys = ignoreDestroys;
        this.kernel = kernel;
    }

    @Override
    public List<String> getBeans() {
        return this.beans;
    }

    @Override
    public URL getURL() {
        return this.deployment;
    }

    @Override
    public ClassLoader getClassLoader() {
        Object bean;
        ClassLoader cl = null;
        if (this.beans != null && this.beans.size() > 0 && (bean = this.kernel.getBean(this.beans.get(0))) != null) {
            cl = SecurityActions.getClassLoader(bean.getClass());
        }
        if (cl == null) {
            cl = this.kernel.getKernelClassLoader();
        }
        return cl;
    }

    public void stop() throws Throwable {
        HashSet<String> remaining = new HashSet<String>();
        remaining.addAll(this.beans);
        for (String bean : this.beans) {
            Set<String> dependants = this.kernel.getBeanDependants(bean);
            if (dependants != null) {
                for (String dependant : dependants) {
                    remaining.remove(dependant);
                }
            }
            remaining.remove(bean);
        }
        if (remaining.size() > 0) {
            throw new Exception("Cannot stop deployment " + this.deployment + " due to remaining dependants " + remaining);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Throwable {
        Throwable throwable = null;
        LinkedList<String> shutdownBeans = new LinkedList<String>(this.beans);
        Collections.reverse(shutdownBeans);
        for (String name : shutdownBeans) {
            try {
                String methodName2;
                Object bean;
                block20: {
                    this.kernel.setBeanStatus(name, ServiceLifecycle.STOPPING);
                    bean = this.kernel.getBean(name);
                    if (bean == null) continue;
                    List<Method> l = this.uninstall.get(name);
                    if (l != null) {
                        for (Method m : l) {
                            try {
                                SecurityActions.setAccessible(m);
                                m.invoke(bean, (Object[])null);
                            }
                            catch (InvocationTargetException ite) {
                                if (throwable != null) continue;
                                throwable = ite.getTargetException();
                            }
                        }
                    }
                    if (this.ignoreStops == null || !this.ignoreStops.contains(name)) {
                        try {
                            methodName2 = "stop";
                            if (this.stops != null && this.stops.containsKey(name)) {
                                methodName2 = this.stops.get(name);
                            }
                            Method stopMethod = SecurityActions.getMethod(bean.getClass(), methodName2, null);
                            SecurityActions.setAccessible(stopMethod);
                            stopMethod.invoke(bean, (Object[])null);
                        }
                        catch (NoSuchMethodException methodName2) {
                        }
                        catch (InvocationTargetException ite) {
                            if (throwable != null) break block20;
                            throwable = ite.getTargetException();
                        }
                    }
                }
                if (this.ignoreDestroys != null && this.ignoreDestroys.contains(name)) continue;
                try {
                    methodName2 = "destroy";
                    if (this.destroys != null && this.destroys.containsKey(name)) {
                        methodName2 = this.destroys.get(name);
                    }
                    Method destroyMethod = SecurityActions.getMethod(bean.getClass(), methodName2, null);
                    SecurityActions.setAccessible(destroyMethod);
                    destroyMethod.invoke(bean, (Object[])null);
                }
                catch (NoSuchMethodException methodName3) {
                }
                catch (InvocationTargetException ite) {
                    if (throwable != null) continue;
                    throwable = ite.getTargetException();
                }
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
            finally {
                this.kernel.removeBean(name);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }
}

