/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import java.lang.reflect.Method;

public class Callback {
    private Class<?> type;
    private Method method;
    private Object instance;
    private transient Integer hashCode;

    public Callback(Class<?> type, Method method, Object instance) {
        if (type == null) {
            throw new IllegalArgumentException("Type is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method is null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Instance is null");
        }
        this.type = type;
        this.method = method;
        this.instance = instance;
        this.hashCode = null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = 7;
            result += 7 * this.type.hashCode();
            result += 7 * this.method.hashCode();
            this.hashCode = result += 7 * System.identityHashCode(this.instance);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Callback)) {
            return false;
        }
        Callback cb = (Callback)obj;
        boolean result = this.type.equals(cb.getType());
        if (result) {
            result = this.method.equals(cb.getMethod());
        }
        if (result) {
            result = System.identityHashCode(this.instance) == System.identityHashCode(cb.getInstance());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Callback[");
        sb = sb.append("Type=" + this.type + ",");
        sb = sb.append("Method=" + this.method + ",");
        sb = sb.append("Instance=" + this.instance);
        sb = sb.append("]");
        return sb.toString();
    }
}

