/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.api.deployment.Bean;
import com.github.fungal.deployment.Unmarshaller;
import com.github.fungal.impl.BeanDeployer;
import com.github.fungal.impl.BeanDeploymentImpl;
import com.github.fungal.impl.KernelImpl;
import com.github.fungal.impl.ServiceLifecycle;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Context;
import com.github.fungal.spi.deployers.DeployException;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DeploymentDeployer
implements CloneableDeployer {
    private Logger log = Logger.getLogger(DeploymentDeployer.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private KernelImpl kernel;

    public DeploymentDeployer(KernelImpl kernel) {
        if (kernel == null) {
            throw new IllegalArgumentException("Kernel is null");
        }
        this.kernel = kernel;
    }

    @Override
    public boolean accepts(URL deployment) {
        if (deployment != null) {
            return deployment.toString().endsWith(".xml");
        }
        return false;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public Deployment deploy(URL url, Context context, ClassLoader parent) throws DeployException {
        DeployException deployException = null;
        try {
            Unmarshaller deploymentU = new Unmarshaller();
            com.github.fungal.deployment.Deployment deployment = deploymentU.unmarshal(url);
            if (deployment != null && deployment.getBean().size() > 0) {
                for (Bean bt : deployment.getBean()) {
                    this.kernel.setBeanStatus(bt.getName(), ServiceLifecycle.NOT_STARTED);
                }
                this.kernel.beansRegistered();
                ArrayList<BeanDeployer> deployers = new ArrayList<BeanDeployer>(deployment.getBean().size());
                List<String> beans = Collections.synchronizedList(new ArrayList(deployment.getBean().size()));
                ConcurrentHashMap<String, List<Method>> uninstall = new ConcurrentHashMap<String, List<Method>>(deployment.getBean().size());
                Map<String, String> stops = Collections.synchronizedMap(new HashMap(deployment.getBean().size()));
                Map<String, String> destroys = Collections.synchronizedMap(new HashMap(deployment.getBean().size()));
                Set<String> ignoreStops = Collections.synchronizedSet(new HashSet(deployment.getBean().size()));
                Set<String> ignoreDestroys = Collections.synchronizedSet(new HashSet(deployment.getBean().size()));
                CountDownLatch beansLatch = new CountDownLatch(deployment.getBean().size());
                for (Bean bt : deployment.getBean()) {
                    BeanDeployer deployer = new BeanDeployer(bt, beans, uninstall, stops, destroys, ignoreStops, ignoreDestroys, this.kernel, beansLatch, parent, this.log);
                    deployers.add(deployer);
                    this.kernel.getExecutorService().submit(deployer);
                }
                beansLatch.await();
                Iterator it = deployers.iterator();
                while (deployException == null && it.hasNext()) {
                    BeanDeployer deployer = (BeanDeployer)it.next();
                    if (deployer.getDeployException() == null) continue;
                    deployException = deployer.getDeployException();
                }
                if (deployException == null) {
                    return new BeanDeploymentImpl(url, beans, uninstall, stops, destroys, ignoreStops, ignoreDestroys, this.kernel);
                }
            }
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, t.getMessage(), t);
            throw new DeployException("Deployment " + url + " failed", t);
        }
        if (deployException != null) {
            throw new DeployException("Deployment " + url + " failed", deployException);
        }
        return null;
    }

    @Override
    public Deployer clone() throws CloneNotSupportedException {
        DeploymentDeployer dd = (DeploymentDeployer)super.clone();
        dd.kernel = this.kernel;
        return dd;
    }
}

