/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.impl.HotDeployerMBean;
import com.github.fungal.impl.KernelImpl;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HotDeployer
implements HotDeployerMBean,
Runnable {
    private Logger log = Logger.getLogger(HotDeployer.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private int interval;
    private File directory;
    private KernelImpl kernel;
    private AtomicBoolean running;
    private List<URL> deployments;
    private Map<String, Long> modifiedTimestamp;

    public HotDeployer(int interval, File directory, KernelImpl kernel) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Internal is invalid");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        if (kernel == null) {
            throw new IllegalArgumentException("Kernel is null");
        }
        this.interval = interval;
        this.directory = directory;
        this.kernel = kernel;
        this.running = new AtomicBoolean(false);
        this.deployments = new ArrayList<URL>();
        this.modifiedTimestamp = new HashMap<String, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(URL deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        try {
            if (!deployment.toExternalForm().startsWith(this.directory.toURI().toURL().toExternalForm())) {
                return;
            }
            List<URL> list = this.deployments;
            synchronized (list) {
                this.deployments.add(deployment);
                File f = new File(deployment.toURI());
                this.modifiedTimestamp.put(deployment.toString(), f.lastModified());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(URL deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        try {
            if (!deployment.toExternalForm().startsWith(this.directory.toURI().toURL().toExternalForm())) {
                return;
            }
            List<URL> list = this.deployments;
            synchronized (list) {
                this.deployments.remove(deployment);
                this.modifiedTimestamp.remove(deployment.toString());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(int value) {
        this.interval = value;
    }

    @Override
    public void start() {
        this.running.set(true);
        this.kernel.getExecutorService().submit(this);
    }

    @Override
    public void stop() {
        this.running.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running.get()) {
            long start = System.currentTimeMillis();
            try {
                long took;
                long sleep;
                ArrayList<URL> removeDeployments = null;
                List<URL> list = this.deployments;
                synchronized (list) {
                    removeDeployments = new ArrayList<URL>(this.deployments);
                }
                ArrayList<URL> changedDeployments = null;
                ArrayList<URL> newDeployments = null;
                boolean postDeploy = false;
                File[] files = this.directory.listFiles();
                for (File f : files) {
                    URL url = f.toURI().toURL();
                    if (removeDeployments.contains(url)) {
                        long modified = this.modifiedTimestamp.get(url.toString());
                        if (f.lastModified() != modified) {
                            if (changedDeployments == null) {
                                changedDeployments = new ArrayList<URL>(1);
                            }
                            changedDeployments.add(url);
                            postDeploy = true;
                        }
                        removeDeployments.remove(url);
                        continue;
                    }
                    if (newDeployments == null) {
                        newDeployments = new ArrayList<URL>(1);
                    }
                    newDeployments.add(url);
                    postDeploy = true;
                }
                if (removeDeployments.size() > 0) {
                    for (URL url : removeDeployments) {
                        try {
                            this.unregister(url);
                            this.kernel.getMainDeployer().undeploy(url);
                        }
                        catch (Throwable undeploy) {
                            this.log.log(Level.SEVERE, undeploy.getMessage(), undeploy);
                        }
                    }
                }
                if (changedDeployments != null) {
                    Collections.sort(changedDeployments, this.kernel.getKernelConfiguration().getDeploymentOrder());
                    for (URL url : changedDeployments) {
                        try {
                            this.unregister(url);
                            this.kernel.getMainDeployer().undeploy(url);
                            this.register(url);
                            this.kernel.getMainDeployer().deploy(url);
                        }
                        catch (Throwable deploy) {
                            this.log.log(Level.SEVERE, deploy.getMessage(), deploy);
                        }
                    }
                }
                if (newDeployments != null) {
                    Collections.sort(newDeployments, this.kernel.getKernelConfiguration().getDeploymentOrder());
                    for (URL url : newDeployments) {
                        try {
                            this.register(url);
                            this.kernel.getMainDeployer().deploy(url);
                        }
                        catch (Throwable deploy) {
                            this.log.log(Level.SEVERE, deploy.getMessage(), deploy);
                        }
                    }
                }
                if (postDeploy) {
                    this.kernel.postDeploy(true);
                }
                if ((sleep = (long)this.interval * 1000L - (took = System.currentTimeMillis() - start)) <= 10L) {
                    sleep = 10L;
                }
                Thread.sleep(sleep);
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, t.getMessage(), t);
            }
        }
    }
}

