/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.impl.SecurityActions;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;

class JmxRemote {
    private static final String SERVER_HOSTNAME = "java.rmi.server.hostname";
    private static final String RMI_BIND_NAME = "jmxrmi";
    private static final int BACKLOG = 50;
    private Logger log = Logger.getLogger(JmxRemote.class.getName());
    private MBeanServer mbeanServer;
    private String bindAddress;
    private int registryPort;
    private int serverPort;
    private RMIConnectorServer adapter;
    private RMIJRMPServerImpl rmiServer;
    private Registry registry;

    JmxRemote(MBeanServer mbeanServer, String bindAddress, int registryPort, int serverPort) {
        this.mbeanServer = mbeanServer;
        this.bindAddress = bindAddress;
        this.registryPort = registryPort;
        this.serverPort = serverPort;
        this.adapter = null;
        this.rmiServer = null;
        this.registry = null;
    }

    void start() throws IOException, RemoteException {
        SecurityActions.setSystemProperty(SERVER_HOSTNAME, this.bindAddress);
        InetAddress ia = InetAddress.getByName(this.bindAddress);
        JMXServerSocketFactory serverSocketFactory = new JMXServerSocketFactory(ia);
        this.registry = LocateRegistry.createRegistry(this.registryPort, null, serverSocketFactory);
        HashMap env = new HashMap();
        this.rmiServer = new RMIJRMPServerImpl(this.serverPort, null, serverSocketFactory, env);
        JMXServiceURL url = this.createJMXServiceURL(this.bindAddress);
        this.adapter = new RMIConnectorServer(url, env, this.rmiServer, this.mbeanServer);
        this.adapter.start();
        this.registry.rebind(RMI_BIND_NAME, this.rmiServer.toStub());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void stop() {
        try {
            this.registry.unbind(RMI_BIND_NAME);
            return;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Could not unbind jmx connector from registry", e);
            return;
        }
        finally {
            try {
                this.adapter.stop();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Could not stop connector server", e);
            }
            finally {
                try {
                    UnicastRemoteObject.unexportObject(this.registry, true);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Could not shutdown rmi registry");
                }
            }
        }
    }

    private JMXServiceURL createJMXServiceURL(String host) throws MalformedURLException {
        if (host.indexOf(58) != -1) {
            host = "[" + host + "]";
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + host);
        return url;
    }

    private static class JMXServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = 1564081885379700777L;
        private final InetAddress address;

        JMXServerSocketFactory(InetAddress address) {
            this.address = address;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 50, this.address);
        }
    }
}

