/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl;

import com.github.fungal.impl.ContextImpl;
import com.github.fungal.impl.DeployerComparator;
import com.github.fungal.impl.Deployers;
import com.github.fungal.impl.KernelImpl;
import com.github.fungal.impl.MainDeployerImplMBean;
import com.github.fungal.spi.deployers.CloneableDeployer;
import com.github.fungal.spi.deployers.Deployer;
import com.github.fungal.spi.deployers.Deployment;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MainDeployerImpl
implements Cloneable,
MainDeployerImplMBean {
    private Logger log = Logger.getLogger(MainDeployerImpl.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINER);
    private KernelImpl kernel;
    private Deployers deployers;

    MainDeployerImpl(KernelImpl kernel, Deployers deployers) {
        if (kernel == null) {
            throw new IllegalArgumentException("Kernel is null");
        }
        if (deployers == null) {
            throw new IllegalArgumentException("Deployers is null");
        }
        this.kernel = kernel;
        this.deployers = deployers;
    }

    void addDeployer(Deployer deployer) {
        this.deployers.addDeployer(deployer);
    }

    @Override
    public synchronized void deploy(URL url) throws Throwable {
        this.deploy(url, true, this.kernel.getKernelClassLoader());
    }

    synchronized void deploy(URL url, boolean deployerPhases, ClassLoader classLoader) throws Throwable {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader is null");
        }
        if (this.trace) {
            this.log.log(Level.FINER, "Deploy: " + url.toExternalForm());
        }
        ArrayList<Deployer> copy = new ArrayList<Deployer>(this.deployers.getDeployers().size());
        for (Deployer deployer : this.deployers.getDeployers()) {
            if (!deployer.accepts(url)) continue;
            if (deployer instanceof CloneableDeployer) {
                try {
                    copy.add(((CloneableDeployer)deployer).clone());
                }
                catch (CloneNotSupportedException cnse) {
                    copy.add(deployer);
                }
                continue;
            }
            copy.add(deployer);
        }
        Collections.sort(copy, new DeployerComparator());
        if (deployerPhases) {
            this.kernel.preDeploy(true);
        }
        ContextImpl context = new ContextImpl(this.kernel);
        Throwable throwable = null;
        try {
            for (int i = 0; i < copy.size(); ++i) {
                Deployer deployer = (Deployer)copy.get(i);
                Deployment deployment = deployer.deploy(url, context, classLoader);
                if (deployment == null) continue;
                this.registerDeployment(deployment);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        context.clear();
        if (deployerPhases && throwable == null) {
            this.kernel.postDeploy(true);
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    @Override
    public synchronized void undeploy(URL url) throws Throwable {
        this.undeploy(url, true);
    }

    synchronized void undeploy(URL url, boolean deployerPhases) throws Throwable {
        List<Deployment> deployments;
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        if (this.trace) {
            this.log.log(Level.FINER, "Undeploy: " + url.toExternalForm());
        }
        if ((deployments = this.kernel.getDeployments(url, false)) != null) {
            if (deployerPhases) {
                this.kernel.preUndeploy(true);
            }
            Collections.reverse(deployments);
            Throwable throwable = null;
            for (Deployment deployment : deployments) {
                try {
                    this.unregisterDeployment(deployment);
                }
                catch (Throwable t) {
                    if (throwable != null) continue;
                    throwable = t;
                }
            }
            if (deployerPhases && throwable == null) {
                this.kernel.postUndeploy(true);
            }
            if (throwable != null) {
                throw throwable;
            }
        }
    }

    @Override
    public synchronized void registerDeployment(Deployment deployment) {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (this.trace) {
            this.log.log(Level.FINER, "RegisterDeployment: " + deployment);
        }
        this.kernel.registerDeployment(deployment);
    }

    @Override
    public synchronized void unregisterDeployment(Deployment deployment) throws Throwable {
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment is null");
        }
        if (this.trace) {
            this.log.log(Level.FINER, "UnregisterDeployment: " + deployment);
        }
        this.kernel.shutdownDeployment(deployment);
    }

    public Object clone() throws CloneNotSupportedException {
        MainDeployerImpl md = (MainDeployerImpl)super.clone();
        md.kernel = this.kernel;
        md.deployers = this.deployers;
        return md;
    }
}

