/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.api.classloading.KernelClassLoader;
import com.github.fungal.impl.classloader.ArchiveClassLoader;
import com.github.fungal.impl.classloader.ExportClassLoaderRepository;
import java.net.URL;
import java.util.Set;

class NonExportClassLoader
extends KernelClassLoader {
    private ExportClassLoaderRepository eclr;

    NonExportClassLoader(ExportClassLoaderRepository eclr) {
        this(new URL[0], ClassLoader.getSystemClassLoader(), eclr);
    }

    private NonExportClassLoader(URL[] urls, ClassLoader cl, ExportClassLoaderRepository eclr) {
        super(urls, cl);
        if (eclr == null) {
            throw new IllegalArgumentException("ECLR is null");
        }
        this.eclr = eclr;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException cnfe) {
            Set<Integer> classLoaders = this.eclr.getClassLoaders();
            for (Integer id : classLoaders) {
                try {
                    ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                    return acl.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw cnfe;
        }
    }

    public Class<?> lookup(String name) throws ClassNotFoundException {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException cnfe) {
            Set<Integer> cls = this.eclr.getClassLoaders(name);
            if (cls != null) {
                for (Integer id : cls) {
                    try {
                        ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                        return acl.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            throw cnfe;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (Throwable t) {
            Set<Integer> classLoaders = this.eclr.getClassLoaders();
            for (Integer id : classLoaders) {
                ArchiveClassLoader acl = this.eclr.getClassLoader(id);
                if (acl == null) continue;
                try {
                    return acl.findClass(name, false);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException("Unable to load class: " + name);
        }
    }

    @Override
    public synchronized void addURL(URL url) {
        super.addURL(url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NonExportClassLoader@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[Eclr=").append(Integer.toHexString(System.identityHashCode(this.eclr)));
        sb.append("]");
        return sb.toString();
    }
}

