/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.classloader;

import com.github.fungal.impl.classloader.ArchiveClassLoader;
import com.github.fungal.impl.classloader.ChildrenClassLoader;
import com.github.fungal.impl.classloader.ExportClassLoaderRepository;
import com.github.fungal.impl.classloader.NonExportClassLoader;
import com.github.fungal.impl.classloader.ParentLastClassLoader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    static ArchiveClassLoader createArchiveClassLoader(final Integer id, final URL url, final Set<String> exportPackages, final ExportClassLoaderRepository repository) {
        if (System.getSecurityManager() == null) {
            return new ArchiveClassLoader(id, url, exportPackages, repository);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ArchiveClassLoader>(){

            @Override
            public ArchiveClassLoader run() {
                return new ArchiveClassLoader(id, url, exportPackages, repository);
            }
        });
    }

    static NonExportClassLoader createNonExportClassLoader(final ExportClassLoaderRepository repository) {
        if (System.getSecurityManager() == null) {
            return new NonExportClassLoader(repository);
        }
        return AccessController.doPrivileged(new PrivilegedAction<NonExportClassLoader>(){

            @Override
            public NonExportClassLoader run() {
                return new NonExportClassLoader(repository);
            }
        });
    }

    static URLClassLoader createURLClassLoader(final URL[] urls, final ClassLoader parent) {
        if (System.getSecurityManager() == null) {
            return new URLClassLoader(urls, parent);
        }
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }

    static ChildrenClassLoader createChildrenClassLoader(final URL[] urls, final ClassLoader parent, final ParentLastClassLoader delegate) {
        if (System.getSecurityManager() == null) {
            return new ChildrenClassLoader(urls, parent, delegate);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ChildrenClassLoader>(){

            @Override
            public ChildrenClassLoader run() {
                return new ChildrenClassLoader(urls, parent, delegate);
            }
        });
    }
}

