/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.netboot;

import com.github.fungal.bootstrap.DependencyType;
import com.github.fungal.bootstrap.ServerType;
import com.github.fungal.impl.netboot.DependencyTracker;
import com.github.fungal.impl.netboot.Pattern;
import com.github.fungal.impl.netboot.Repository;
import com.github.fungal.impl.netboot.ResolveException;
import com.github.fungal.spi.netboot.Protocol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractRepository
implements Repository {
    @Override
    public File getFile(DependencyType dependency, File repository) throws IOException {
        File f = new File(repository, this.getPath(dependency));
        if (f.exists()) {
            return f;
        }
        throw new IOException("Dependency " + dependency + " doesn't exist in the repository " + repository.getAbsolutePath());
    }

    protected List<DependencyType> downloadArtifact(List<ServerType> servers, Map<String, Protocol> protocolMap, DependencyType dependency, File repository, DependencyTracker tracker) throws ResolveException {
        if (tracker.isTracked(dependency)) {
            return Collections.emptyList();
        }
        if (!tracker.track(dependency)) {
            return Collections.emptyList();
        }
        List<DependencyType> result = this.getArtifact(repository, dependency);
        if (result != null) {
            return result;
        }
        result = new ArrayList<DependencyType>(1);
        File f = new File(repository, this.getPath(dependency));
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new ResolveException(f.getParent() + " couldn't be created");
        }
        Iterator<ServerType> it = servers.iterator();
        while (result.isEmpty() && it.hasNext()) {
            try {
                Protocol protocol;
                ServerType server = it.next();
                String path = server.getValue();
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + Pattern.resolve(server.getPattern(), dependency.getOrganisation(), dependency.getModule(), dependency.getRevision(), dependency.getArtifact(), dependency.getClassifier(), dependency.getExt());
                String protocolKey = server.getProtocol();
                if (protocolKey == null || protocolKey.trim().equals("")) {
                    protocolKey = "http";
                }
                if ((protocol = protocolMap.get(protocolKey)) != null) {
                    Protocol copy = protocol.clone();
                    if (!copy.download(path, f)) continue;
                    result.add(dependency);
                    continue;
                }
                throw new ResolveException("Protocol (" + protocolKey + ") not defined for server " + server.getValue());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
        }
        if (result.isEmpty()) {
            throw new ResolveException("The dependency couldn't be resolved", dependency);
        }
        return result;
    }

    protected List<DependencyType> getArtifact(File repository, DependencyType dependency) {
        File f = new File(repository, this.getPath(dependency));
        if (f.exists()) {
            ArrayList<DependencyType> l = new ArrayList<DependencyType>(1);
            l.add(dependency);
            return l;
        }
        return null;
    }

    protected String getPath(DependencyType dependency) {
        String path = dependency.getOrganisation().replace('.', File.separatorChar) + File.separatorChar + dependency.getArtifact() + File.separatorChar + dependency.getRevision() + File.separatorChar + dependency.getArtifact() + "-" + dependency.getRevision() + "." + dependency.getExt();
        return path;
    }

    @Override
    public abstract List<DependencyType> resolve(List<ServerType> var1, Map<String, Protocol> var2, DependencyType var3, File var4, DependencyTracker var5) throws ResolveException;
}

