/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.netboot;

import com.github.fungal.bootstrap.DependencyType;
import com.github.fungal.bootstrap.ServerType;
import com.github.fungal.impl.netboot.AbstractRepository;
import com.github.fungal.impl.netboot.DependencyTracker;
import com.github.fungal.impl.netboot.MavenUnmarshaller;
import com.github.fungal.impl.netboot.ResolveException;
import com.github.fungal.spi.netboot.Protocol;
import java.io.File;
import java.util.List;
import java.util.Map;

public class Maven
extends AbstractRepository {
    @Override
    public List<DependencyType> resolve(List<ServerType> servers, Map<String, Protocol> protocolMap, DependencyType dependency, File repository, DependencyTracker tracker) throws ResolveException {
        if ("pom".equals(dependency.getExt())) {
            return this.downloadPom(servers, protocolMap, dependency, repository, tracker);
        }
        return this.downloadArtifact(servers, protocolMap, dependency, repository, tracker);
    }

    private List<DependencyType> downloadPom(List<ServerType> servers, Map<String, Protocol> protocolMap, DependencyType dependency, File repository, DependencyTracker tracker) throws ResolveException {
        List<DependencyType> result = this.downloadArtifact(servers, protocolMap, dependency, repository, tracker);
        if (result.size() == 0) {
            return result;
        }
        try {
            MavenUnmarshaller unmarshaller = new MavenUnmarshaller();
            File f = new File(repository, this.getPath(dependency));
            List<DependencyType> dependencies = unmarshaller.unmarshal(f.toURI().toURL());
            if (dependencies != null && dependencies.size() > 0) {
                for (DependencyType dep : dependencies) {
                    List<DependencyType> l = this.downloadArtifact(servers, protocolMap, dep, repository, tracker);
                    result.addAll(l);
                }
            }
            return result;
        }
        catch (Throwable t) {
            throw new ResolveException("The dependency couldn't be parsed", dependency);
        }
    }
}

