/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.netboot;

import com.github.fungal.bootstrap.DependencyType;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MavenUnmarshaller {
    public List<DependencyType> unmarshal(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("File is null");
        }
        InputStream is = null;
        try {
            ArrayList<DependencyType> result = new ArrayList<DependencyType>(1);
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.toURI());
                is = new FileInputStream(file);
            } else if ("jar".equals(url.getProtocol())) {
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                is = jarConnection.getInputStream();
            } else {
                throw new IOException("Unsupport protocol: " + url);
            }
            is = new BufferedInputStream(is, 4096);
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            while (xmlStreamReader.hasNext()) {
                int eventCode = xmlStreamReader.next();
                switch (eventCode) {
                    case 1: {
                        if (!"dependency".equals(xmlStreamReader.getLocalName())) break;
                        result.add(this.readDependency(xmlStreamReader));
                        break;
                    }
                }
            }
            ArrayList<DependencyType> arrayList = result;
            return arrayList;
        }
        catch (Throwable t) {
            throw new IOException(t.getMessage(), t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private DependencyType readDependency(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        DependencyType result = new DependencyType();
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 1: {
                    String name = xmlStreamReader.getLocalName();
                    if ("groupId".equals(name)) {
                        result.setOrganisation(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("artifactId".equals(name)) {
                        result.setArtifact(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("version".equals(name)) {
                        result.setRevision(this.readString(xmlStreamReader));
                        break;
                    }
                    if ("type".equals(name)) {
                        result.setExt(this.readString(xmlStreamReader));
                        break;
                    }
                    this.ignoreTag(xmlStreamReader);
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        if (!"dependency".equals(xmlStreamReader.getLocalName())) {
            throw new XMLStreamException("dependency tag not completed", xmlStreamReader.getLocation());
        }
        return result;
    }

    private String readString(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String result = null;
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            switch (eventCode) {
                case 4: {
                    if (xmlStreamReader.getText().trim().equals("")) break;
                    result = xmlStreamReader.getText().trim();
                    break;
                }
            }
            eventCode = xmlStreamReader.next();
        }
        return result;
    }

    private void ignoreTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        int eventCode = xmlStreamReader.next();
        while (eventCode != 2) {
            eventCode = xmlStreamReader.next();
        }
    }
}

