/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.netboot;

import com.github.fungal.api.util.FileUtil;
import com.github.fungal.api.util.Injection;
import com.github.fungal.bootstrap.Bootstrap;
import com.github.fungal.bootstrap.DependencyType;
import com.github.fungal.bootstrap.PropertyType;
import com.github.fungal.bootstrap.ProtocolType;
import com.github.fungal.bootstrap.ServerType;
import com.github.fungal.impl.netboot.DependencyTracker;
import com.github.fungal.impl.netboot.Http;
import com.github.fungal.impl.netboot.Maven;
import com.github.fungal.impl.netboot.ResolveException;
import com.github.fungal.impl.netboot.SecurityActions;
import com.github.fungal.spi.netboot.Protocol;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public class Netboot {
    private Netboot() {
    }

    public static boolean resolve(ExecutorService executorService, Bootstrap bootstrap, File repositoryDirectory, File rootDirectory) throws ResolveException {
        if (bootstrap != null && bootstrap.getServers() != null && bootstrap.getServers().getServer().size() > 0 && bootstrap.getDependencies() != null && bootstrap.getDependencies().getDependency().size() > 0) {
            if (!repositoryDirectory.exists() && !repositoryDirectory.mkdirs()) {
                throw new ResolveException("Repository directory " + repositoryDirectory.getAbsolutePath() + " couldn't be created");
            }
            if (!rootDirectory.exists()) {
                throw new ResolveException("Root directory " + rootDirectory.getAbsolutePath() + " doesn't exist");
            }
            try {
                DependencyTracker tracker = new DependencyTracker();
                List<DependencyType> dependencies = bootstrap.getDependencies().getDependency();
                List<ProtocolType> protocols = bootstrap.getProtocols().getProtocol();
                List<ServerType> servers = bootstrap.getServers().getServer();
                HashMap<String, Protocol> protocolMap = new HashMap<String, Protocol>(protocols.size() != 0 ? protocols.size() : 1);
                if (protocols.size() > 0) {
                    Injection injection = new Injection();
                    for (ProtocolType protocolType : protocols) {
                        if (protocolType.getId() == null || protocolType.getId().trim().equals("")) {
                            throw new IllegalArgumentException("Protocol id must be defined");
                        }
                        if (protocolType.getClassName() == null || protocolType.getClassName().trim().equals("")) {
                            throw new IllegalArgumentException("Protocol class name must be defined");
                        }
                        Class<?> clz = null;
                        try {
                            clz = Class.forName(protocolType.getClassName(), true, SecurityActions.getThreadContextClassLoader());
                        }
                        catch (Exception e) {
                            clz = Class.forName(protocolType.getClassName(), true, SecurityActions.getClassLoader(Netboot.class));
                        }
                        Protocol p = (Protocol)clz.newInstance();
                        for (PropertyType property : protocolType.getProperty()) {
                            injection.inject(p, property.getName(), property.getValue());
                        }
                        protocolMap.put(protocolType.getId(), p);
                    }
                } else {
                    protocolMap.put("http", new Http());
                }
                ArrayList<DependencyResolver> dependencyResolvers = new ArrayList<DependencyResolver>(dependencies.size());
                CountDownLatch dependencyLatch = new CountDownLatch(dependencies.size());
                for (DependencyType dependency : dependencies) {
                    DependencyResolver dependencyResolver = new DependencyResolver(servers, protocolMap, dependency, repositoryDirectory, rootDirectory, tracker, dependencyLatch);
                    dependencyResolvers.add(dependencyResolver);
                    executorService.execute(dependencyResolver);
                }
                dependencyLatch.await();
                for (DependencyResolver resolver : dependencyResolvers) {
                    if (resolver.getResolveException() == null) continue;
                    throw resolver.getResolveException();
                }
                return true;
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new ResolveException("Interrupted while resolving dependencies");
            }
            catch (Throwable t) {
                throw new ResolveException("Exception while resolving dependencies", t);
            }
        }
        return false;
    }

    static class DependencyResolver
    implements Runnable {
        private List<ServerType> servers;
        private Map<String, Protocol> protocolMap;
        private DependencyType dependency;
        private File repositoryDirectory;
        private File rootDirectory;
        private DependencyTracker tracker;
        private CountDownLatch latch;
        private ResolveException resolveException;

        public DependencyResolver(List<ServerType> servers, Map<String, Protocol> protocolMap, DependencyType dependency, File repositoryDirectory, File rootDirectory, DependencyTracker tracker, CountDownLatch latch) {
            this.servers = servers;
            this.protocolMap = protocolMap;
            this.dependency = dependency;
            this.repositoryDirectory = repositoryDirectory;
            this.rootDirectory = rootDirectory;
            this.tracker = tracker;
            this.latch = latch;
            this.resolveException = null;
        }

        @Override
        public void run() {
            try {
                Maven repository = new Maven();
                List<DependencyType> artifacts = repository.resolve(this.servers, this.protocolMap, this.dependency, this.repositoryDirectory, this.tracker);
                if (artifacts != null) {
                    FileUtil fileUtil = new FileUtil();
                    for (DependencyType dependency : artifacts) {
                        File src = repository.getFile(dependency, this.repositoryDirectory);
                        File dest = new File(this.rootDirectory, dependency.getTarget().replace('/', File.separatorChar) + File.separatorChar + dependency.getArtifact() + "." + dependency.getExt());
                        if (dest.getParentFile() != null && !dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
                            throw new ResolveException("Directory " + dest.getParentFile().getAbsolutePath() + " couldn't be created");
                        }
                        fileUtil.copy(src, dest);
                    }
                }
            }
            catch (IOException ioe) {
                this.resolveException = new ResolveException("IOException while resolving", ioe);
            }
            catch (ResolveException re) {
                this.resolveException = re;
            }
            this.latch.countDown();
        }

        public ResolveException getResolveException() {
            return this.resolveException;
        }
    }
}

