/*
 * Decompiled with CFR 0.152.
 */
package com.github.fungal.impl.remote.commands;

import com.github.fungal.api.remote.Command;
import com.github.fungal.impl.remote.CommunicationServer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Help
implements Command {
    private static final String NAME = "help";
    private Logger log = Logger.getLogger(Help.class.getName());
    private boolean trace = this.log.isLoggable(Level.FINEST);
    private CommunicationServer cs;

    public Help(CommunicationServer cs) {
        this.cs = cs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class[] getParameterTypes() {
        return null;
    }

    @Override
    public Serializable invoke(Serializable[] args) {
        if (args != null) {
            return new IllegalArgumentException("Unsupported argument list: " + Arrays.toString(args));
        }
        StringBuilder sb = new StringBuilder();
        Set<String> commands = this.cs.getCommandNames();
        if (commands != null) {
            for (String commandName : commands) {
                Command command = this.cs.getCommand(commandName);
                if (!command.isPublic()) continue;
                sb = sb.append(commandName);
                Class[] parameterTypes = command.getParameterTypes();
                if (parameterTypes != null) {
                    sb = sb.append(" ");
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        Class parameterType = parameterTypes[i];
                        sb = sb.append("<");
                        sb = sb.append(parameterType.getName());
                        sb = sb.append(">");
                        if (i >= parameterTypes.length - 1) continue;
                        sb = sb.append(" ");
                    }
                }
                sb = sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isPublic() {
        return true;
    }
}

