/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.Statement;

public interface DataSource
extends CommonDataSource {
    public String getConnectionUrl();

    public String getDriverClass();

    public String getModule();

    public Map<String, String> getConnectionProperties();

    public Statement getStatement();

    public String getUrlDelimiter();

    public String getUrlSelectorStrategyClassName();

    public String getNewConnectionSql();

    public CommonPool getPool();

    public static enum Attribute {
        JNDINAME("jndi-name"),
        POOL_NAME("pool-name"),
        ENABLED("enabled"),
        USEJAVACONTEXT("use-java-context");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        POOL("pool"),
        CONNECTIONURL("connection-url"),
        DRIVERCLASS("driver-class"),
        MODULE("module"),
        TRANSACTIONISOLATION("transaction-isolation"),
        CONNECTIONPROPERTY("connection-property"),
        TIMEOUT("time-out"),
        SECURITY("security"),
        STATEMENT("statement"),
        VALIDATION("validation"),
        URLDELIMITER("url-delimiter"),
        URLSELECTORSTRATEGYCLASSNAME("url-selector-strategy-className"),
        NEWCONNECTIONSQL("new-connection-sql");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

