/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.JCAMetadata;

public interface CommonAdminObject
extends JCAMetadata {
    public Map<String, String> getConfigProperties();

    public String getClassName();

    public String getJndiName();

    public String getPoolName();

    public Boolean isEnabled();

    public Boolean isUseJavaContext();

    public static enum Attribute {
        UNKNOWN(null),
        JNDINAME("jndi-name"),
        CLASS_NAME("class-name"),
        POOL_NAME("pool-name"),
        ENABLED("enabled"),
        USEJAVACONTEXT("use-java-context");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        CONFIG_PROPERTY("config-property");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

